-- ============================================================================
-- >>>>>>>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<
-- ============================================================================
--
-- NAME:        Text_IO_Supplement
--
--              BODY
-- 
-- AUTHOR:      Chuck Hobin
--
-- DATE:        12 January 1994
--
--                               CHANGE HISTORY
--
-- MM-DD-YY | Initials | Description
-- ----------------------------------------------------------------------------
-- 02-23-94     CWH     Added function Standard_Error.
-- 03-05-94     CWH     Now uses Posix Ada binding to get Standard_Error.
-- 03-31-94     TPS     Commented out the Posix Ada binding stuff as per a 
--                      Rational provided work around to an Apex error 
--                      (Log 56959) to be fixed in Rational 1.4 due in May
-- NOTE: restore the commented out code (--***) when we update to Apex 1.4
--       and delete the code indicated by (--delete for Apex 1.4)
-- 01-25-95     CWH     Restored code that was commented out in the 3/31/94
--                      change.  Tested against Apex 1.4.
-- ============================================================================
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
--
--                        ------------------------------
--                        Ada Environment-Dependent Code
--                        ------------------------------
--
--                        Environment : Rational Apex
--
-- !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

with Posix_Io;
with Posix_Supplement_To_Ada_Io;
with Text_Io;

package body Text_Io_Supplement is

    Form_Value : Posix_Supplement_To_Ada_Io.Form_Values_For_Open;
    Standard_Error_File : Text_Io.File_Type;

-------------------------------------------------------------------------------

    -- In Apex, Get_Line does not raise End_Error when the line being read
    -- has a file terminator with no preceding line terminator. (In other
    -- words, Get_Line behaves as it should.)

    procedure Get_Line (File : in Text_Io.File_Type; 
			Item : out String; 
			Last : out Natural) is
    begin
	Text_Io.Get_Line (File, Item, Last);
    end Get_Line;

-------------------------------------------------------------------------------

    function Standard_Error return Text_Io.File_Type is
    begin
	return Standard_Error_File;
    end Standard_Error;

-------------------------------------------------------------------------------

begin  -- package elaboration code

       -- Equate a Text_IO file object with the Posix file descriptor
       -- for Standard_Error.

    Form_Value.File_Descriptor := (True, Posix_Io.Standard_Error);
    Text_Io.Open (Standard_Error_File, 
		  Mode => Text_Io.Out_File, 
		  Name => "", 
		  Form => Posix_Supplement_To_Ada_Io.Form_String (Form_Value));

end Text_Io_Supplement;
