-- =====================================================================
-- >>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT  <<<<<<<<<<<<<<<<<<<<<<<<<
-- =====================================================================
--
-- NAME:        Control_Flow_Defs
--
--              SPECIFICATION 
-- 
-- AUTHOR:      Pilar Montes
--              General Research Corporation
--
-- PURPOSE:     Declares data structures used to represent a 
--              control flow view.
--
--                            CHANGE HISTORY
--
-- MM-DD-YY | Initials | Description
-- ---------------------------------------------------------------------
-- 04-14-94   PNM        Incorporated C. Hobin's suggestions resulting
--                       from his code walkthrough.
-- 05-04-94   PNM        Added the Free_View procedure.
-- =====================================================================
-- =====================================================================

with Asis;
with Graph_Directed_Unbounded_Managed;
with Set_Simple_Sequential_Unbounded_Managed_Iterator;

package Control_Flow_Defs is

----------------------------------------------------------------------
-- Incomplete Type and Access Type Declarations
----------------------------------------------------------------------

    type Edge_Type;
    type Edge_Type_Ptr is access Edge_Type;
    type Item_Type;
    type Item_Type_Ptr is access Item_Type;
    type Handler_Type;
    type Handler_Type_Ptr is access Handler_Type;

----------------------------------------------------------------------
-- Generic Package Instantiations
----------------------------------------------------------------------

    package Control_Graph is 
       new Graph_Directed_Unbounded_Managed 
	      (Item => Item_Type_Ptr, Attribute => Edge_Type_Ptr);

    package Handler_Set is new Set_Simple_Sequential_Unbounded_Managed_Iterator 
				  (Item => Handler_Type_Ptr);

----------------------------------------------------------------------
-- Type and Access Type Declarations
----------------------------------------------------------------------

    type Node_Kind_Type is (Start, Statement, Terminal, If_Statement_Arm);

    type Edge_Kind_Type is (Prog_Unit_Start, Condition_True, 
			    Condition_False, Case_Alt, Select_Arm, 
			    Block_Body_Start, Accept_Body_Start, 
			    Propagated_Raise, Handled_Raise, Continuation);

    ----------------------------------------------------------

    -- The edge (arc) type in the control flow graph.

    type Edge_Type is
	record
	    Kind : Edge_Kind_Type;
	    Element : Asis.Element;
	end record;

    ----------------------------------------------------------

    -- The node (vertex) type in the control flow graph.

    type Item_Type is
	record
	    Kind : Node_Kind_Type;
	    Element : Asis.Element;
	    -- Statement or If_Statement_Arm
	end record;

    ----------------------------------------------------------

    -- The handler type maps the exception handler with the node
    -- in the control flow graph.

    type Handler_Type is
	record
	    Handler : Asis.Exception_Handler;
	    Node : Control_Graph.Vertex;
	end record;

    ----------------------------------------------------------

    -- Control Flow Graph View.

    type View_Type is
	record
	    Graph : Control_Graph.Graph;
	    Start : Control_Graph.Vertex;
	    Body_Decl : Asis.Declaration;
	    Handlers : Handler_Set.Set;
	    Terminal : Control_Graph.Vertex;
	end record;


    type Control_Flow_View is access View_Type;

end Control_Flow_Defs;






