-- ============================================================================
-- >>>>>>>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<
-- ============================================================================
--
-- NAME:        Control_Flow_Save
--
--              SPEC
--
-- AUTHOR:      Pilar Montes
--              General Research Corporation
--
--                            CHANGE 
--
-- MM-DD-YY | Initials | Description
-- ---------------------------------------------------------------------------
-- 04-27-94   PNM        Remove Graph_File global variable.
-- 01-24-95   CWH        Revised interface.
-- ===========================================================================

with Control_Flow_Defs;
with Text_Io;

package Control_Flow_Save is

------------------------------------------------------------------------------
-- Save_In_Grl_Format
-- 
-- Creates a textual representation of a control flow view in Graph
-- Representation Language (GRL) format.
-- 
-- The GRL language is used to desribe the nodes and edges of a directed
-- graph, along with layout and formatting directives for a visual 
-- display of the graph.  GRL was developed to support the Extendible
-- Directed Graph Editor (EDGE) from the University of Karlsruhe, Germany
-- (F.N. Paulisch and W.F. Tichy, "EDGE : An Extendible Graph Editor,"
-- Software - Practice and Experience, 20(S1), pp. 63-88, June 1990).
-- EDGE is available via ftp from iraun1.ira.uka.de.
-- 
-- To facilitate testing the control flow view, we used EDGE to display
-- a set of test views for visual inspection.  The views were output
-- as text in the GRL language, enabling them to be read directly by EDGE.
-- 
-- The GRL file created by this operation simply describes the nodes and
-- edges of the control flow graph; no layout and formatting information 
-- is included. (Layout/formatting can be controlled interactively in EDGE).
-- 
-- A sample GRL file for a control flow view is shown below.  Each node
-- in the flow graph is labeled with the element kind of the corresponding
-- ASIS element and its source line number.  Each edge is denoted
-- by the labels of the source and target nodes, and is itself labelled with 
-- the edge kind from the view.
-- 
-- graph: {
-- /* list of nodes */
-- node: { title: " A_PROCEDURE_CALL_STATEMENT( 113)" }
-- node: { title: " AN_ASSIGNMENT_STATEMENT( 90)" }
-- node: { title: " A_RETURN_STATEMENT( 87)" }
--  .
--  .
--  .
-- /* list of edges */
-- edge: { sourcename: " A_PROCEDURE_CALL_STATEMENT( 86)" 
--         targetname: " A_RETURN_STATEMENT( 87)" 
--         label: "CONTINUATION" }
-- edge: { sourcename: " AN_IF_ARM( 85)" 
--         targetname: " A_PROCEDURE_CALL_STATEMENT( 86)" 
--         label: "CONDITION_TRUE" }
-- edge: { sourcename: " A_RETURN_STATEMENT( 71)" 
--         targetname: " Terminal" 
--         label: "CONTINUATION" }
--  .
--  .
--  .
-- }
--
------------------------------------------------------------------------------

    procedure Save_In_Grl_Format (The_View : in 
				     Control_Flow_Defs.Control_Flow_View; 
				  To_The_File : in Text_Io.File_Type);

end Control_Flow_Save;


