--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_SUBTYPE_INDICATION (body)                           |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Subtype_Indication (The_Indication : in Asis.Subtype_Indication; 
				   The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Subtype_Indication";
    Puid : constant String := "Scan_Subtype_Indication";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Indication) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Indication, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Indication);
	end;
	return;
    end if;

    declare
	Constraint : Asis.Constraint := 
	   Asis_Td.Subtype_Constraint (The_Indication);
	Type_Mark : Asis.Expression := Asis_Td.Type_Mark (The_Indication);
    begin

	if Trace.On then
	    Trace.Log (The_Indication);
	    Trace.Add_Level (1 + Namespace_Scan.One_If_Present (Constraint));
	end if;

	Namespace_Scan.Scan_Expression (Type_Mark, The_Context);

	if not Asis_E.Is_Nil (Constraint) then
	    Namespace_Scan.Scan_Constraint (Constraint, The_Context);
	end if;

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Indication);
	raise;

end Scan_Subtype_Indication;
