--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_DECLARATIVE_ITEM_LIST (body)                        |
--| |                                                                         |
--| | Scans a list of declarations, pragmas, representation clauses, and      |
--| | use clauses.                                                            |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Declarative_Item_List (The_List : in Asis.Declarative_Item_List; 
				      The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Declarative_Item_List";
    Puid : constant String := "Scan_Declarative_Item_List";

    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_Declaration =>
		Reference_Scan.Scan_Declaration (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Reference_Scan.Scan_Pragma (The_Element, The_Context);
	    when Asis_E.A_Representation_Clause =>
		Reference_Scan.Scan_Representation_Clause 
		   (The_Element, The_Context);
	    when Asis_E.A_Use_Clause =>
		Reference_Scan.Scan_Use_Clause (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Reference_Scan.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		else
		    if Trace.On then
			Trace.Log (The_Element, The_Context);
		    end if;
		end if;
	end case;
    end loop;

end Scan_Declarative_Item_List;
