--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_DECLARATIVE_REGION_PART (body)                      |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Declarative_Region_Part 
	     (The_Region : in Rgn.Region; The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Declarative_Region_Part";
    Puid : constant String := "Scan_Declarative_Region_Part";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

    Current_Element : Asis.Element;
    Current_Unit : Asis.Compilation_Unit;

begin

    if Rgn."=" (Rgn.Kind (The_Region), Rgn.A_Compilation_Unit) then
	Current_Unit := Rgn.Head_Unit (The_Region);
    else
	Current_Element := Rgn.Head_Element (The_Region);
    end if;

    case Rgn.Kind (The_Region) is
	when Rgn.A_Compilation_Unit =>
	    declare
		Context_Clauses : constant Asis.Context_Clause_List := 
		   Asis_Cu.Context_Clause_Elements 
		      (Current_Unit, Reference_Scan.
					Include_Context_Clause_Pragmas);
		Declared_Unit : Asis.Declaration := 
		   Asis_Cu.Unit_Declaration (Current_Unit);
	    begin
		if Trace.On then
		    Trace.Log (Current_Unit, The_Context);
		    Trace.Add_Level (Context_Clauses'Length + 1);
		end if;
		Reference_Scan.Scan_Context_Clause_List 
		   (Context_Clauses, 
		    Ctx.Set (The_Context, 
			     Basic_Context => Rvs.A_Use_Context_Clause, 
			     Weight => 85));
		Reference_Scan.Scan_Declaration (Declared_Unit, The_Context);
	    end;
	when Rgn.A_Record_Type_Declaration =>
	    declare
		Discriminants : constant Asis.Discriminant_Specification_List := 
		   Asis_D.Discriminants (Current_Element);
		The_Type : Asis.Type_Definition := 
		   Asis_D.Type_Declaration_Definition (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Discriminants'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List 
		   (Discriminants, The_Context);
		Reference_Scan.Scan_Type_Definition (The_Type, The_Context);
	    end;
	when Rgn.An_Incomplete_Type_Declaration =>
	    declare
		Discriminants : constant Asis.Discriminant_Specification_List := 
		   Asis_D.Discriminants (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Discriminants'Length);
		end if;
		Reference_Scan.Scan_Declaration_List 
		   (Discriminants, The_Context);
	    end;
	when Rgn.A_Private_Type_Declaration =>
	    declare
		Discriminants : constant Asis.Discriminant_Specification_List := 
		   Asis_D.Discriminants (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Discriminants'Length);
		end if;
		Reference_Scan.Scan_Declaration_List 
		   (Discriminants, The_Context);
	    end;
	when Rgn.A_Package_Specification_Visible_Part =>
	    declare
		Public_Declarations : constant Asis.Declarative_Item_List := 
		   Asis_D.Visible_Part_Declarative_Items 
		      (Current_Element, Reference_Scan.Include_Package_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Public_Declarations'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Public_Declarations, The_Context);
	    end;
	when Rgn.A_Package_Specification_Private_Part =>
	    declare
		Private_Declarations : constant Asis.Declarative_Item_List := 
		   Asis_D.Private_Part_Declarative_Items 
		      (Current_Element, Reference_Scan.Include_Package_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Private_Declarations'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Private_Declarations, The_Context);
	    end;
	when Rgn.A_Package_Body =>
	    declare
		The_Body : Asis.Statement := 
		   Asis_D.Package_Body_Block (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (1);
		end if;
		Reference_Scan.Scan_Statement (The_Body, The_Context);
	    end;
	when Rgn.A_Procedure_Specification =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
	    end;
	when Rgn.A_Procedure_Body =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		The_Body : Asis.Statement := 
		   Asis_D.Subprogram_Body_Block (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Statement (The_Body, The_Context);
	    end;
	when Rgn.A_Function_Specification =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		Return_Type : Asis.Expression := 
		   Asis_D.Return_Type (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Expression 
		   (Return_Type, 
		    Ctx.Set (The_Context, 
			     Basic_Context => Rvs.A_Type_Mark, 
			     Weight => 90, 
			     Type_Mark_Context => Rvs.A_Function_Declaration));
	    end;
	when Rgn.A_Function_Body =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		Return_Type : Asis.Expression := 
		   Asis_D.Return_Type (Current_Element);
		The_Body : Asis.Statement := 
		   Asis_D.Subprogram_Body_Block (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 2);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Expression 
		   (Return_Type, 
		    Ctx.Set (The_Context, 
			     Basic_Context => Rvs.A_Type_Mark, 
			     Weight => 90, 
			     Type_Mark_Context => Rvs.A_Function_Body));
		Reference_Scan.Scan_Statement (The_Body, The_Context);
	    end;
	when Rgn.A_Procedure_Rename_Declaration =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
	    end;
	when Rgn.A_Function_Rename_Declaration =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		Return_Type : Asis.Expression := 
		   Asis_D.Return_Type (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Expression 
		   (Return_Type, 
		    Ctx.Set (The_Context, 
			     Basic_Context => Rvs.A_Type_Mark, 
			     Weight => 90, 
			     Type_Mark_Context => Rvs.A_Function_Rename));
	    end;
	when Rgn.A_Generic_Package_Formal_Part =>
	    declare
		Formal_Parameters : constant Asis.
					     Generic_Formal_Parameter_List := 
		   Asis_D.Generic_Formal_Parameters 
		      (Current_Element, Reference_Scan.
					   Include_Generic_Formal_Part_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Formal_Parameters'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Formal_Parameters, The_Context);
	    end;
	when Rgn.A_Generic_Package_Specification_Visible_Part =>
	    declare
		Public_Declarations : constant Asis.Declarative_Item_List := 
		   Asis_D.Visible_Part_Declarative_Items 
		      (Current_Element, Reference_Scan.Include_Package_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Public_Declarations'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Public_Declarations, The_Context);
	    end;
	when Rgn.A_Generic_Package_Specification_Private_Part =>
	    declare
		Private_Declarations : constant Asis.Declarative_Item_List := 
		   Asis_D.Private_Part_Declarative_Items 
		      (Current_Element, Reference_Scan.Include_Package_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Private_Declarations'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Private_Declarations, The_Context);
	    end;
	when Rgn.A_Generic_Procedure_Formal_Part =>
	    declare
		Formal_Parameters : constant Asis.
					     Generic_Formal_Parameter_List := 
		   Asis_D.Generic_Formal_Parameters 
		      (Current_Element, Reference_Scan.
					   Include_Generic_Formal_Part_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Formal_Parameters'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Formal_Parameters, The_Context);
	    end;
	when Rgn.A_Generic_Procedure_Specification_Part =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
	    end;
	when Rgn.A_Generic_Function_Formal_Part =>
	    declare
		Formal_Parameters : constant Asis.
					     Generic_Formal_Parameter_List := 
		   Asis_D.Generic_Formal_Parameters 
		      (Current_Element, Reference_Scan.
					   Include_Generic_Formal_Part_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Formal_Parameters'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Formal_Parameters, The_Context);
	    end;
	when Rgn.A_Generic_Function_Specification_Part =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		Return_Type : Asis.Expression := 
		   Asis_D.Return_Type (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Expression 
		   (Return_Type, 
		    Ctx.Set (The_Context, 
			     Basic_Context => Rvs.A_Type_Mark, 
			     Weight => 90, 
			     Type_Mark_Context => Rvs.A_Generic_Function));
	    end;
	when Rgn.A_Task_Declaration =>
	    declare
		Declarations : constant Asis.Declarative_Item_List := 
		   Asis_D.Task_Declaration_Declarative_Items 
		      (Current_Element, Reference_Scan.
					   Include_Task_Declaration_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Declarations'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Declarations, The_Context);
	    end;
	when Rgn.A_Task_Body =>
	    declare
		The_Body : Asis.Statement := 
		   Asis_D.Task_Body_Block (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (1);
		end if;
		Reference_Scan.Scan_Statement (The_Body, The_Context);
	    end;
	when Rgn.A_Task_Type_Declaration =>
	    declare
		The_Type : Asis.Type_Definition := 
		   Asis_D.Type_Declaration_Definition (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (1);
		end if;
		Reference_Scan.Scan_Type_Definition (The_Type, The_Context);
	    end;
	when Rgn.An_Entry_Declaration =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
	    end;
	when Rgn.A_Procedure_Body_Stub =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
	    end;
	when Rgn.A_Function_Body_Stub =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		Return_Type : Asis.Expression := 
		   Asis_D.Return_Type (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Expression 
		   (Return_Type, 
		    Ctx.Set (The_Context, 
			     Basic_Context => Rvs.A_Type_Mark, 
			     Weight => 90, 
			     Type_Mark_Context => Rvs.A_Function_Stub));
	    end;
	when Rgn.A_Package_Body_Stub =>
	    if Trace.On then
		Trace.Log (Current_Element, The_Context);
	    end if;
	when Rgn.A_Task_Body_Stub =>
	    if Trace.On then
		Trace.Log (Current_Element, The_Context);
	    end if;
	when Rgn.A_Generic_Formal_Private_Type_Declaration =>
	    declare
		Discriminants : constant Asis.Discriminant_Specification_List := 
		   Asis_D.Discriminants (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Discriminants'Length);
		end if;
		Reference_Scan.Scan_Declaration_List 
		   (Discriminants, The_Context);
	    end;
	when Rgn.A_Generic_Formal_Procedure_Specification =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
	    end;
	when Rgn.A_Generic_Formal_Function_Specification =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_D.Parameters (Current_Element);
		Return_Type : Asis.Expression := 
		   Asis_D.Return_Type (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + 1);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Expression 
		   (Return_Type, Ctx.Set (The_Context, 
					  Basic_Context => Rvs.A_Type_Mark, 
					  Weight => 90, 
					  Type_Mark_Context => 
					     Rvs.A_Generic_Formal_Function));
	    end;
	when Rgn.A_For_Loop_Statement =>
	    declare
		Scheme : Asis.Declaration := 
		   Asis_S.For_Loop_Parameter_Specification (Current_Element);
		Statements : constant Asis.Statement_List := 
		   Asis_S.Loop_Statements 
		      (Current_Element, Reference_Scan.
					   Include_Loop_Statement_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (1 + Statements'Length);
		end if;
		Reference_Scan.Scan_Declaration (Scheme, The_Context);
		Reference_Scan.Scan_Statement_List (Statements, The_Context);
	    end;
	when Rgn.A_While_Loop_Statement =>
	    declare
		Condition : Asis.Expression := 
		   Asis_S.While_Condition (Current_Element);
		Statements : constant Asis.Statement_List := 
		   Asis_S.Loop_Statements 
		      (Current_Element, Reference_Scan.
					   Include_Loop_Statement_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (1 + Statements'Length);
		end if;
		Reference_Scan.Scan_Expression 
		   (Condition, Ctx.Set (The_Context, 
					Basic_Context => Rvs.A_Read, 
					Weight => 5, 
					Add_Data_Access_Context => 
					   Rvs.A_While_Loop_Condition));
		Reference_Scan.Scan_Statement_List (Statements, The_Context);
	    end;
	when Rgn.A_Simple_Loop_Statement =>
	    declare
		Statements : constant Asis.Statement_List := 
		   Asis_S.Loop_Statements 
		      (Current_Element, Reference_Scan.
					   Include_Loop_Statement_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Statements'Length);
		end if;
		Reference_Scan.Scan_Statement_List (Statements, The_Context);
	    end;
	when Rgn.A_Block_Statement =>
	    declare
		Declarations : constant Asis.Declarative_Item_List := 
		   Asis_S.Declarative_Items 
		      (Current_Element, Reference_Scan.
					   Include_Block_Statement_Pragmas);
		Handlers : constant Asis.Exception_Handler_List := 
		   Asis_S.Block_Exception_Handlers (Current_Element);
		Statements : constant Asis.Statement_List := 
		   Asis_S.Block_Body_Statements 
		      (Current_Element, Reference_Scan.
					   Include_Block_Statement_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Declarations'Length + 
				     Statements'Length + Handlers'Length);
		end if;
		Reference_Scan.Scan_Declarative_Item_List 
		   (Declarations, The_Context);
		Reference_Scan.Scan_Statement_List (Statements, The_Context);
		Reference_Scan.Scan_Exception_Handler_List 
		   (Handlers, The_Context);
	    end;
	when Rgn.An_Accept_Statement =>
	    declare
		Parameters : constant Asis.Parameter_Specification_List := 
		   Asis_S.Accept_Parameters (Current_Element);
		Statements : constant Asis.Statement_List := 
		   Asis_S.Accept_Body_Statements 
		      (Current_Element, Reference_Scan.
					   Include_Accept_Statement_Pragmas);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level (Parameters'Length + Statements'Length);
		end if;
		Reference_Scan.Scan_Declaration_List (Parameters, The_Context);
		Reference_Scan.Scan_Statement_List (Statements, The_Context);
	    end;
	when Rgn.A_Record_Representation_Clause =>
	    declare
		Alignment : Asis.Expression := 
		   Asis_Rc.
		      Record_Representation_Clause_Alignment_Clause_Expression 
		      (Current_Element);
		Component_Clauses : constant Asis.Component_Clause_List := 
		   Asis_Rc.Component_Clauses 
		      (Current_Element, 
		       Reference_Scan.
			  Include_Record_Representation_Clause_Pragmas);
		Pragmas : constant Asis.Element_List := 
		   Asis_Rc.Record_Representation_Clause_Alignment_Clause_Pragmas 
		      (Current_Element);
	    begin
		if Trace.On then
		    Trace.Log (Current_Element, The_Context);
		    Trace.Add_Level 
		       (Reference_Scan.One_If_True 
			   (Reference_Scan.
			    Include_Record_Representation_Clause_Pragmas) * 
			Pragmas'Length + 
			Reference_Scan.One_If_Present (Alignment) + 
			Component_Clauses'Length);
		end if;
		if Reference_Scan.
		   Include_Record_Representation_Clause_Pragmas then
		    Reference_Scan.Scan_Pragma_List (Pragmas, The_Context);
		end if;
		if not Asis_E.Is_Nil (Alignment) then
		    Reference_Scan.Scan_Expression 
		       (Alignment, Ctx.Set (The_Context, 
					    Basic_Context => Rvs.A_Read, 
					    Weight => 5, 
					    Add_Data_Access_Context => 
					       Rvs.An_Alignment_Clause));
		end if;
		Reference_Scan.Scan_Component_Clause_List 
		   (Component_Clauses, The_Context);
	    end;
    end case;

exception

    when Asis.Asis_Inappropriate_Compilation_Unit | 
	 Asis.Asis_Inappropriate_Element =>
	if Rgn."=" (Rgn.Kind (The_Region), Rgn.A_Compilation_Unit) then
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, Current_Unit);
	else
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, Current_Element);
	end if;
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	if Rgn."=" (Rgn.Kind (The_Region), Rgn.A_Compilation_Unit) then
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, Current_Unit);
	else
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, Current_Element);
	end if;
	raise Traversal_Error;

    when Traversal_Error =>
	if Rgn."=" (Rgn.Kind (The_Region), Rgn.A_Compilation_Unit) then
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, Current_Unit);
	else
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, Current_Element);
	end if;
	raise;

end Scan_Declarative_Region_Part;
