--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_USE_CLAUSE (body)                                   |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Use_Clause (The_Clause : in Asis.Context_Clause; 
			   The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Use_Clause";
    Puid : constant String := "Scan_Use_Clause";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Packages : constant Asis.Expression_List := 
	   Asis_X.Named_Packages (The_Clause);
    begin

	if Trace.On then
	    Trace.Log (The_Clause, The_Context);
	    Trace.Add_Level (Packages'Length);
	end if;

	Reference_Scan.Scan_Expression_List 
	   (Packages, Ctx.Set (The_Context, 
			       Basic_Context => Rvs.A_Use_Clause, 
			       Weight => 80));

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Clause);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Clause);
	raise;

end Scan_Use_Clause;
