--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_VARIANT_PART (body)                                 |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Variant_Part (The_Part : in Asis.Record_Component; 
			     The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Variant_Part";
    Puid : constant String := "Scan_Variant_Part";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Discriminant_Name : Asis.Simple_Name := 
	   Asis_Td.Corresponding_Discriminant_Simple_Name (The_Part);
	Variants : constant Asis.Variant_List := 
	   Asis_Td.Variants 
	      (The_Part, Reference_Scan.Include_Record_Type_Definition_Pragmas);
    begin

	if Trace.On then
	    Trace.Log (The_Part, The_Context);
	    Trace.Add_Level (1 + Variants'Length);
	end if;

	Reference_Scan.Scan_Expression 
	   (Discriminant_Name, 
	    Ctx.Set (The_Context, 
		     Basic_Context => Rvs.A_Variant_Part_Discriminant, 
		     Weight => 90));

	Reference_Scan.Scan_Variant_List (Variants, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Part);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Part);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Part);
	raise;

end Scan_Variant_Part;
