-- 
-- File Name: type_test.1.ada
-- 
generic

    -- Gt2 defines a region; Gt1 does not.

    type Gt1 is private;
    type Gt2 (D1 : Integer) is limited private;

package Type_Test is

    -- T1 defines a region.

    type T1 is
	record
	    A : Integer;
	end record;

    for T1 use
	record
	    A at 0 range 0 .. 31;
	end record;

    -- T2 does not define a region.

    type T2;
    type T2 is new Integer;

    -- T3 defines a region; T4 does not.

    type T3 is private;
    type T4 is limited private;

private

    type T3 is
	record
	    B : Integer;
	end record;

    for T3 use
	record
	    B at 0 range 0 .. 31;
	end record;

    -- T5 (completed in body) defines a region.

    type T5;

    type T4 is access T5;

    -- T6 (completed in body) does not define a region.

    type T6;

    type T7 is access T6;

end Type_Test;

