--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_IF_STATEMENT_ARM (body)           |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_If_Statement_Arm (The_Arm : in Asis.If_Statement_Arm; 
				 The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_If_Statement_Arm";
    Puid : constant String := "Scan_If_Statement_Arm";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

--| +-------------------------------------------------------------------------+
--| | SCAN_ELSE_ARM (local)                                                   |
--| +-------------------------------------------------------------------------+

    procedure Scan_Else_Arm (The_Arm : in Asis.If_Statement_Arm; 
			     The_Context : in out Context) is

	Puid : constant String := "Scan_Else_Arm";

    begin

	declare
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Region_Scan_Internal.Include_If_Statement_Pragmas);
	begin

	    Region_Scan_Internal.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_Else_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_ELSIF_ARM (local)                                                  |
--| +-------------------------------------------------------------------------+

    procedure Scan_Elsif_Arm (The_Arm : in Asis.If_Statement_Arm; 
			      The_Context : in out Context) is

	Puid : constant String := "Scan_Elsif_Arm";

    begin

	declare
	    Condition : Asis.Expression := 
	       Asis_S.Condition_Expression (The_Arm);
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Region_Scan_Internal.Include_If_Statement_Pragmas);
	begin

	    Region_Scan_Internal.Scan_Expression (Condition, The_Context);

	    Region_Scan_Internal.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_Elsif_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_IF_ARM (local)                                                     |
--| +-------------------------------------------------------------------------+

    procedure Scan_If_Arm (The_Arm : in Asis.If_Statement_Arm; 
			   The_Context : in out Context) is

	Puid : constant String := "Scan_If_Arm";

    begin

	declare
	    Condition : Asis.Expression := 
	       Asis_S.Condition_Expression (The_Arm);
	    Statements : constant Asis.Statement_List := 
	       Asis_S.Arm_Statements 
		  (The_Arm, Region_Scan_Internal.Include_If_Statement_Pragmas);
	begin

	    Region_Scan_Internal.Scan_Expression (Condition, The_Context);

	    Region_Scan_Internal.Scan_Statement_List (Statements, The_Context);

	end;

    exception

	when Asis.Asis_Inappropriate_Element =>
	    Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Asis.Asis_Failed =>
	    Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Arm);
	    raise Traversal_Error;

	when Traversal_Error =>
	    Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Arm);
	    raise;

    end Scan_If_Arm;

--| +-------------------------------------------------------------------------+
--| | SCAN_IF_STATEMENT_ARM (exported)                                        |
--| +-------------------------------------------------------------------------+

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Arm, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Arm, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Arm, Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    case Asis_S.If_Statement_Arm_Kind (The_Arm) is
	when Asis_S.An_If_Arm =>
	    Scan_If_Arm (The_Arm, The_Context);
	when Asis_S.An_Elsif_Arm =>
	    Scan_Elsif_Arm (The_Arm, The_Context);
	when Asis_S.An_Else_Arm =>
	    Scan_Else_Arm (The_Arm, The_Context);
	when Asis_S.Not_An_If_Statement_Arm =>
	    Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Arm);
	    if Region_Scan_Internal.Raise_Exception_On_Unhandled_Case then
		raise Traversal_Error;
	    end if;
    end case;

end Scan_If_Statement_Arm;
