--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_PRAGMA (body)                     |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Pragma (The_Pragma : in Asis.Pragma_Element; 
		       The_Context : in out Context) is

    Cuid : constant String := "Region_Scan.Region_Scan_Internal.Scan_Pragma";
    Puid : constant String := "Scan_Pragma";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Pragma, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Pragma, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Pragma, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Arguments : constant Asis.Argument_Association_List := 
	   Asis_E.Argument_Associations (The_Pragma);
    begin

	Region_Scan_Internal.Scan_Argument_Association_List 
	   (Arguments, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Pragma);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Pragma);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Pragma);
	raise;

end Scan_Pragma;
