--| +=========================================================================+
--| |                                                                         |
--| | SCAN.SCAN_COMPONENT_CLAUSE_LIST (body)                                  |
--| |                                                                         |
--| | Scans a list of record representation component clauses and pragmas.    |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Scan)
procedure Scan_Component_Clause_List (The_List : in Asis.Component_Clause_List; 
				      The_Context : in out Context) is

    Cuid : constant String := "Scan.Scan_Component_Clause_List";
    Puid : constant String := "Scan_Component_Clause_List";

    package Error renames Scan.Error_Handling_Support;
    package Trace renames Scan.Trace_Support;

    The_Element : Asis.Element;

begin

    for I in The_List'Range loop
	The_Element := The_List (I);
	case Asis_E.Element_Kind (The_Element) is
	    when Asis_E.A_Component_Clause =>
		Scan.Scan_Component_Clause (The_Element, The_Context);
	    when Asis_E.A_Pragma =>
		Scan.Scan_Pragma (The_Element, The_Context);
	    when others =>
		Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
		if Scan.Raise_Exception_On_Unhandled_Case then
		    raise Traversal_Error;
		else
		    if Trace.On then
			Trace.Log (The_Element);
		    end if;
		end if;
	end case;
    end loop;

end Scan_Component_Clause_List;
