--| +=========================================================================+
--| |                                                                         |
--| | SCAN.SCAN_PRAGMA (body)                                                 |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Scan)
procedure Scan_Pragma (The_Pragma : in Asis.Pragma_Element; 
		       The_Context : in out Context) is

    Cuid : constant String := "Scan.Scan_Pragma";
    Puid : constant String := "Scan_Pragma";

    package Error renames Scan.Error_Handling_Support;
    package Trace renames Scan.Trace_Support;

begin

    declare
	Arguments : constant Asis.Argument_Association_List := 
	   Asis_E.Argument_Associations (The_Pragma);
    begin

	if Trace.On then
	    Trace.Log (The_Pragma);
	    Trace.Add_Level (Arguments'Length);
	end if;

	Scan.Scan_Argument_Association_List (Arguments, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Pragma);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Pragma);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Pragma);
	raise;

end Scan_Pragma;
