-- ============================================================================
-- >>>>>>>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<
-- ============================================================================
--
-- NAME:        Command
--
--              BODY
-- 
-- AUTHOR:      Chuck Hobin
--
-- DATE:        05 March 1994
--
--                               CHANGE HISTORY
--
-- MM-DD-YY | Initials | Description
-- ----------------------------------------------------------------------------
-- <include SPR#, if applicable>
-- ============================================================================

-- Package variant for : Rational Apex

with Posix;
with Posix_Process_Environment;

package body Command is

    -- The state of this package is a String_Ptr_Array that is constructed
    -- from the Posix Argument_List the first time an operation of this
    -- package is invoked.

    type String_Ptr_Array_Ptr is access String_Ptr_Array;

    Argument_Array : String_Ptr_Array_Ptr;

    Command_Has_Been_Read : Boolean := False;



    procedure Read_Command is
	Index : Natural := 0;

	procedure Copy_Argument (Argument : in Posix.Posix_String; 
				 Quit : in out Boolean) is
	begin
	    Argument_Array (Index) := new String (Argument'Range);
	    Argument_Array (Index).all := Posix.To_String (Argument);
	    Index := Index + 1;
	    Quit := False;
	end Copy_Argument;

	procedure Build_Argument_Array is 
	   new Posix.For_Every_Item (Action => Copy_Argument);
    begin
	Argument_Array := 
	   new String_Ptr_Array 
		  (0 .. Posix.Length (Posix_Process_Environment.Argument_List) - 
			   1);
	Build_Argument_Array (Posix_Process_Environment.Argument_List);
    end Read_Command;



    function Argc return Natural is
    begin
	if not Command_Has_Been_Read then
	    Read_Command;
	    Command_Has_Been_Read := True;
	end if;
	return Argument_Array'Length;
    end Argc;

    function Arguments return String_Ptr_Array is
    begin
	if not Command_Has_Been_Read then
	    Read_Command;
	    Command_Has_Been_Read := True;
	end if;
	return Argument_Array.all;
    end Arguments;

end Command;
