-- ============================================================================
-- >>>>>>>>>>>>>>>>>>>>>>>>>> ADA COMPILATION UNIT <<<<<<<<<<<<<<<<<<<<<<<<<<<<
-- ============================================================================
--
-- NAME:        Text_IO_Supplement
--
--              SPECIFICATION
-- 
-- AUTHOR:      Chuck Hobin
--
-- DATE:        12 January 1994
--
--                               CHANGE HISTORY
--
-- MM-DD-YY | Initials | Description
-- ----------------------------------------------------------------------------
-- 02-23-94     CWH     Added function Standard_Error.
-- ============================================================================

-- The operations in this package:
--   * Mimic or are similar in function to operations provided by the
--     predefined package Text_Io
--   * Have implementations that vary depending on the Ada environment
--     this package is running under.

with Text_Io;

package Text_Io_Supplement is

    procedure Get_Line (File : in Text_Io.File_Type; 
			Item : out String; 
			Last : out Natural);

    -- Functionally identical to Text_IO.Get_Line, except does not raise End_Error
    -- if a file terminator is not preceded by a line terminator.
    -- (VADS 6.1 raises End_Error under these conditions.)
    -- For Ada environments that do not exhibit this behavior, the operation
    -- simply calls Text_Io.Get_Line.

    function Standard_Error return Text_Io.File_Type;

    -- In the same way that Text_IO.Standard_Output returns the standard output
    -- file, this function returns the file representing the Standard Error device.

end Text_Io_Supplement;
