--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_ANY (body)                                          |
--| |                                                                         |
--| | Scans any kind of element.                                              |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Any (The_Element : in Asis.Element; The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Any";
    Puid : constant String := "Scan_Any";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    case Asis_E.Element_Kind (The_Element) is
	when Asis_E.A_Pragma =>
	    Namespace_Scan.Scan_Pragma (The_Element, The_Context);
	when Asis_E.An_Argument_Association =>
	    Namespace_Scan.Scan_Argument_Association (The_Element, The_Context);
	when Asis_E.A_Declaration =>
	    Namespace_Scan.Scan_Declaration (The_Element, The_Context);
	when Asis_E.An_Entity_Name_Definition =>
	    Namespace_Scan.Scan_Entity_Name_Definition 
	       (The_Element, The_Context);
	when Asis_E.A_Type_Definition =>
	    Namespace_Scan.Scan_Type_Definition (The_Element, The_Context);
	when Asis_E.A_Subtype_Indication =>
	    Namespace_Scan.Scan_Subtype_Indication (The_Element, The_Context);
	when Asis_E.A_Constraint =>
	    Namespace_Scan.Scan_Constraint (The_Element, The_Context);
	when Asis_E.A_Discrete_Range =>
	    Namespace_Scan.Scan_Discrete_Range (The_Element, The_Context);
	when Asis_E.A_Discriminant_Association =>
	    Namespace_Scan.Scan_Discriminant_Association 
	       (The_Element, The_Context);
	when Asis_E.A_Variant_Part =>
	    Namespace_Scan.Scan_Variant_Part (The_Element, The_Context);
	when Asis_E.A_Null_Component =>
	    Namespace_Scan.Scan_Null_Component (The_Element, The_Context);
	when Asis_E.A_Variant =>
	    Namespace_Scan.Scan_Variant (The_Element, The_Context);
	when Asis_E.A_Choice =>
	    Namespace_Scan.Scan_Choice (The_Element, The_Context);
	when Asis_E.A_Component_Association =>
	    Namespace_Scan.Scan_Component_Association 
	       (The_Element, The_Context);
	when Asis_E.An_Expression =>
	    Namespace_Scan.Scan_Expression (The_Element, The_Context);
	when Asis_E.A_Statement =>
	    Namespace_Scan.Scan_Statement (The_Element, The_Context);
	when Asis_E.An_If_Statement_Arm =>
	    Namespace_Scan.Scan_If_Statement_Arm (The_Element, The_Context);
	when Asis_E.A_Case_Statement_Alternative =>
	    Namespace_Scan.Scan_Case_Statement_Alternative 
	       (The_Element, The_Context);
	when Asis_E.A_Parameter_Association =>
	    Namespace_Scan.Scan_Parameter_Association 
	       (The_Element, The_Context);
	when Asis_E.A_Use_Clause =>
	    Namespace_Scan.Scan_Use_Clause (The_Element, The_Context);
	when Asis_E.A_Select_Statement_Arm =>
	    Namespace_Scan.Scan_Select_Statement_Arm (The_Element, The_Context);
	when Asis_E.A_Select_Alternative =>
	    Namespace_Scan.Scan_Select_Alternative (The_Element, The_Context);
	when Asis_E.A_With_Clause =>
	    Namespace_Scan.Scan_With_Clause (The_Element, The_Context);
	when Asis_E.An_Exception_Handler =>
	    Namespace_Scan.Scan_Exception_Handler (The_Element, The_Context);
	when Asis_E.A_Representation_Clause =>
	    Namespace_Scan.Scan_Representation_Clause 
	       (The_Element, The_Context);
	when Asis_E.A_Component_Clause =>
	    Namespace_Scan.Scan_Component_Clause (The_Element, The_Context);
	when Asis_E.Not_An_Element =>
	    Error.Log (Error.An_Unhandled_Case, Cuid, Puid, The_Element);
	    if Namespace_Scan.Raise_Exception_On_Unhandled_Case then
		raise Traversal_Error;
	    else
		if Trace.On then
		    Trace.Log (The_Element);
		end if;
	    end if;
    end case;

end Scan_Any;
