--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_PARAMETER_ASSOCIATION (body)                        |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Parameter_Association (The_Association : in Asis.Association; 
				      The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Parameter_Association";
    Puid : constant String := "Scan_Parameter_Association";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Association) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Association, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Association);
	end;
	return;
    end if;

    declare
	Actual_Part : Asis.Expression := 
	   Asis_S.Actual_Parameter (The_Association);
	Formal_Part : Asis.Element := Asis_S.Formal_Parameter (The_Association);
    begin

	if Trace.On then
	    Trace.Log (The_Association);
	    Trace.Add_Level (Namespace_Scan.One_If_Present (Formal_Part) + 1);
	end if;

	if Asis_X.Is_Normalized (The_Association) then
	    Namespace_Scan.Scan_Entity_Name_Definition 
	       (Formal_Part, The_Association);
	else
	    if not Asis_E.Is_Nil (Formal_Part) then
		Namespace_Scan.Scan_Expression (Formal_Part, The_Context);
	    end if;
	end if;

	Namespace_Scan.Scan_Expression (Actual_Part, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Association);
	raise;

end Scan_Parameter_Association;
