--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_VARIANT (body)                                      |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Variant (The_Variant : in Asis.Variant; 
			The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Variant";
    Puid : constant String := "Scan_Variant";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Variant) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements 
		  (The_Variant, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Variant);
	end;
	return;
    end if;

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_Td.Variant_Choices (The_Variant);
	Components : constant Asis.Variant_Component_List := 
	   Asis_Td.Variant_Components 
	      (The_Variant, Namespace_Scan.
			       Include_Record_Type_Definition_Pragmas);
	Implicit_Components : constant Asis.Variant_Component_List := 
	   Asis_Td.Implicit_Variant_Components (The_Variant);
    begin

	if Trace.On then
	    Trace.Log (The_Variant);
	    Trace.Add_Level 
	       (Choices'Length + 
		Namespace_Scan.One_If_True 
		   (Namespace_Scan.Include_Implicit_Record_Components) * 
		Implicit_Components'Length + 
		Components'Length);
	end if;

	Namespace_Scan.Scan_Choice_List (Choices, The_Context);

	if Namespace_Scan.Include_Implicit_Record_Components then
	    Namespace_Scan.Scan_Declaration_List 
	       (Implicit_Components, The_Context);
	end if;

	Namespace_Scan.Scan_Record_Component_List (Components, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Variant);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Variant);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Variant);
	raise;

end Scan_Variant;
