--| +=========================================================================+
--| |                                                                         |
--| | NAMESPACE_SCAN.SCAN_VARIANT_PART (body)                                 |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Namespace_Scan)
procedure Scan_Variant_Part (The_Part : in Asis.Record_Component; 
			     The_Context : in Context) is

    Cuid : constant String := "Namespace_Scan.Scan_Variant_Part";
    Puid : constant String := "Scan_Variant_Part";

    package Error renames Namespace_Scan.Error_Handling_Support;
    package Trace renames Namespace_Scan.Trace_Support;

begin

    if Namespace_Scan.Obeying_Regions and then 
       Rgn.Denotes_One_Or_More_Regions (The_Part) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Part, Include_Pragmas => False);
	begin
	    Namespace_Scan.Scan_Any_List (Remaining_Parent_Elements, The_Part);
	end;
	return;
    end if;

    declare
	Discriminant_Name : Asis.Simple_Name := 
	   Asis_Td.Corresponding_Discriminant_Simple_Name (The_Part);
	Variants : constant Asis.Variant_List := 
	   Asis_Td.Variants 
	      (The_Part, Namespace_Scan.Include_Record_Type_Definition_Pragmas);
    begin

	if Trace.On then
	    Trace.Log (The_Part);
	    Trace.Add_Level (1 + Variants'Length);
	end if;

	Namespace_Scan.Scan_Expression (Discriminant_Name, The_Context);

	Namespace_Scan.Scan_Variant_List (Variants, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Part);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Part);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Part);
	raise;

end Scan_Variant_Part;
