--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_COMPONENT_ASSOCIATION (body)                        |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Component_Association 
	     (The_Association : in Asis.Component_Association; 
	      The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Component_Association";
    Puid : constant String := "Scan_Component_Association";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

    Choice_Context : Context;

begin

    if Rvs."=" (The_Context.Basic_Context, 
		Rvs.An_Enumeration_Representation_Clause) then
	Choice_Context := Ctx.Set (The_Context, 
				   Basic_Context => Rvs.A_Component_Association, 
				   Weight => 92);
    else
	declare
	    The_Aggregate : Asis.Expression;
	    The_Aggregate_Ground_Type : Asis.Type_Definition;
	    The_Aggregate_Type : Asis.Type_Definition;
	begin
	    The_Aggregate := Asis_E.Enclosing_Element (The_Association);
	    The_Aggregate_Type := Asis_X.Expression_Type (The_Aggregate);
	    The_Aggregate_Ground_Type := 
	       Asis_Td.Ground_Type (The_Aggregate_Type);
	    case Asis_Td.Kind (The_Aggregate_Ground_Type) is
		when Asis_Td.An_Array_Type_Definition =>
		    Choice_Context := Ctx.Set (The_Context, 
					       Basic_Context => Rvs.A_Read, 
					       Weight => 95, 
					       New_Weight => 5);
		when Asis_Td.A_Record_Type_Definition =>
		    Choice_Context := 
		       Ctx.Set (The_Context, 
				Basic_Context => Rvs.A_Component_Association, 
				Weight => 92);
		when others =>
		    Error.Semantic_Error 
		       ("unhandled case", 
			"starting from.enclosing element.expression type." & 
			   "ground type.", 
			(The_Association, The_Aggregate, 
			 The_Aggregate_Type, The_Aggregate_Ground_Type), 
			Cuid, Puid);
		    raise Traversal_Error;
	    end case;
	exception
	    when Asis.Asis_Inappropriate_Element | Asis.Asis_Failed =>
		Error.Semantic_Error 
		   ("exception raised", 
		    "starting from.enclosing element.expression type." & 
		       "ground type.", 
		    (The_Association, The_Aggregate, 
		     The_Aggregate_Type, The_Aggregate_Ground_Type), 
		    Cuid, Puid);
		raise;
	end;
    end if;

    declare
	Actual_Part : Asis.Expression := 
	   Asis_X.Component_Expression (The_Association);
	Formal_Part : constant Asis.Choice_List := 
	   Asis_X.Component_Choices (The_Association);
    begin

	if Trace.On then
	    Trace.Log (The_Association, The_Context);
	    Trace.Add_Level (Formal_Part'Length + 1);
	end if;

	Reference_Scan.Scan_Choice_List (Formal_Part, Choice_Context);

	Reference_Scan.Scan_Expression 
	   (Actual_Part, 
	    Ctx.Set (The_Context, 
		     Basic_Context => Rvs.A_Read, 
		     Weight => 95, 
		     New_Weight => 5, 
		     Add_Data_Access_Context => Rvs.A_Component_Association));

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Association);
	raise;

end Scan_Component_Association;
