--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_DISCRIMINANT_ASSOCIATION (body)                     |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Discriminant_Association 
	     (The_Association : in Asis.Discriminant_Association; 
	      The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Discriminant_Association";
    Puid : constant String := "Scan_Discriminant_Association";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Actual_Part : Asis.Expression := 
	   Asis_Td.Discriminant_Expression (The_Association);
	Formal_Part : constant Asis.Simple_Name_List := 
	   Asis_Td.Discriminant_Simple_Names (The_Association);
    begin

	if Trace.On then
	    Trace.Log (The_Association, The_Context);
	    Trace.Add_Level (Reference_Scan.One_If_True 
				(not Asis_X.Is_Normalized (The_Association)) * 
			     Formal_Part'Length + 1);
	end if;

	if not Asis_X.Is_Normalized (The_Association) then
	    Reference_Scan.Scan_Expression_List 
	       (Formal_Part, Ctx.Set (The_Context, 
				      Basic_Context => 
					 Rvs.A_Discriminant_Association, 
				      Weight => 90));
	end if;

	Reference_Scan.Scan_Expression 
	   (Actual_Part, Ctx.Set (The_Context, 
				  Basic_Context => Rvs.A_Read, 
				  Weight => 95, 
				  New_Weight => 5, 
				  Add_Data_Access_Context => 
				     Rvs.A_Discriminant_Association));

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Association);
	raise;

end Scan_Discriminant_Association;
