--| +=========================================================================+
--| |                                                                         |
--| | REFERENCE_SCAN.SCAN_SUBTYPE_INDICATION (body)                           |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Reference_Scan)
procedure Scan_Subtype_Indication (The_Indication : in Asis.Subtype_Indication; 
				   The_Context : in Context) is

    Cuid : constant String := "Reference_Scan.Scan_Subtype_Indication";
    Puid : constant String := "Scan_Subtype_Indication";

    package Ctx renames Reference_Scan.Context_Support;
    package Error renames Reference_Scan.Error_Handling_Support;
    package Trace renames Reference_Scan.Trace_Support;

begin

    declare
	Constraint : Asis.Constraint := 
	   Asis_Td.Subtype_Constraint (The_Indication);
	Type_Mark : Asis.Expression := Asis_Td.Type_Mark (The_Indication);
    begin

	if Trace.On then
	    Trace.Log (The_Indication, The_Context);
	    Trace.Add_Level (1 + Reference_Scan.One_If_Present (Constraint));
	end if;

	Reference_Scan.Scan_Expression 
	   (Type_Mark, Ctx.Set (The_Context, 
				Basic_Context => Rvs.A_Type_Mark, 
				Weight => 90));

	if not Asis_E.Is_Nil (Constraint) then
	    Reference_Scan.Scan_Constraint (Constraint, The_Context);
	end if;

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Indication);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Indication);
	raise;

end Scan_Subtype_Indication;
