--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_CASE_STATEMENT_ALTERNATIVE (body) |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Case_Statement_Alternative 
	     (The_Alternative : in Asis.Case_Statement_Alternative; 
	      The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Case_Statement_Alternative";
    Puid : constant String := "Scan_Case_Statement_Alternative";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Alternative, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Alternative, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Alternative, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_S.Case_Statement_Alternative_Choices (The_Alternative);
	Statements : constant Asis.Statement_List := 
	   Asis_S.Case_Statement_Alternative_Statements 
	      (The_Alternative, Region_Scan_Internal.
				   Include_Case_Statement_Pragmas);
    begin

	Region_Scan_Internal.Scan_Choice_List (Choices, The_Context);

	Region_Scan_Internal.Scan_Statement_List (Statements, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Alternative);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Alternative);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Alternative);
	raise;

end Scan_Case_Statement_Alternative;
