--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_DISCRIMINANT_ASSOCIATION (body)   |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Discriminant_Association 
	     (The_Association : in Asis.Discriminant_Association; 
	      The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Discriminant_Association";
    Puid : constant String := "Scan_Discriminant_Association";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Association, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Association, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Association, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Actual_Part : Asis.Expression := 
	   Asis_Td.Discriminant_Expression (The_Association);
	Formal_Part : constant Asis.Simple_Name_List := 
	   Asis_Td.Discriminant_Simple_Names (The_Association);
    begin

	if Asis_X.Is_Normalized (The_Association) then
	    Region_Scan_Internal.Scan_Entity_Name_Definition_List 
	       (Formal_Part, The_Context);
	else
	    Region_Scan_Internal.Scan_Expression_List 
	       (Formal_Part, The_Context);
	end if;

	Region_Scan_Internal.Scan_Expression (Actual_Part, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Association);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Association);
	raise;

end Scan_Discriminant_Association;
