--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_EXCEPTION_HANDLER (body)          |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Exception_Handler (The_Handler : in Asis.Exception_Handler; 
				  The_Context : in out Context) is

    Cuid : constant String := 
       "Region_Scan.Region_Scan_Internal.Scan_Exception_Handler";
    Puid : constant String := "Scan_Exception_Handler";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Handler, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Handler, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Handler, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_S.Exception_Choices (The_Handler);
	Statements : constant Asis.Statement_List := 
	   Asis_S.Handler_Statements 
	      (The_Handler, Region_Scan_Internal.
			       Include_Exception_Handler_Pragmas);
    begin

	Region_Scan_Internal.Scan_Choice_List (Choices, The_Context);

	Region_Scan_Internal.Scan_Statement_List (Statements, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Handler);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Handler);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Handler);
	raise;

end Scan_Exception_Handler;
