--| +=========================================================================+
--| |                                                                         |
--| | REGION_SCAN.REGION_SCAN_INTERNAL.SCAN_VARIANT (body)                    |
--| |                                                                         |
--| | Greg Janee                                                              |
--| | General Research Corporation                                            |
--| |                                                                         |
--| +=========================================================================+

separate (Region_Scan.Region_Scan_Internal)
procedure Scan_Variant (The_Variant : in Asis.Variant; 
			The_Context : in out Context) is

    Cuid : constant String := "Region_Scan.Region_Scan_Internal.Scan_Variant";
    Puid : constant String := "Scan_Variant";

    package Error renames Region_Scan_Internal.Error_Handling_Support;

begin

    if Rgn.Denotes_One_Or_More_Regions (The_Variant, 
					Region_Scan.Expand_Instantiations) then
	declare
	    Remaining_Parent_Elements : constant Asis.Element_List := 
	       Rgn.Non_Region_Subelements (The_Variant, 
					   Region_Scan.Expand_Instantiations);
	    Regions : constant Rgn.Region_List := 
	       Rgn.Denoted_Regions (The_Variant, 
				    Region_Scan.Expand_Instantiations, 
				    Region_Scan.Include_Instance_Bodies);
	begin
	    Region_Scan_Internal.Scan_Any_List 
	       (Remaining_Parent_Elements, The_Context);
	    for I in Regions'Range loop
		Region_Scan.Process_Region (Regions (I), The_Context);
	    end loop;
	end;
	return;
    end if;

    declare
	Choices : constant Asis.Choice_List := 
	   Asis_Td.Variant_Choices (The_Variant);
	Components : constant Asis.Variant_Component_List := 
	   Asis_Td.Variant_Components 
	      (The_Variant, Region_Scan_Internal.
			       Include_Record_Type_Definition_Pragmas);
	Implicit_Components : constant Asis.Variant_Component_List := 
	   Asis_Td.Implicit_Variant_Components (The_Variant);
    begin

	Region_Scan_Internal.Scan_Choice_List (Choices, The_Context);

	if Region_Scan_Internal.Include_Implicit_Record_Components then
	    Region_Scan_Internal.Scan_Declaration_List 
	       (Implicit_Components, The_Context);
	end if;

	Region_Scan_Internal.Scan_Record_Component_List 
	   (Components, The_Context);

    end;

exception

    when Asis.Asis_Inappropriate_Element =>
	Error.Log (Error.A_Bad_Element, Cuid, Puid, The_Variant);
	raise Traversal_Error;

    when Asis.Asis_Failed =>
	Error.Log (Error.An_Asis_Failure, Cuid, Puid, The_Variant);
	raise Traversal_Error;

    when Traversal_Error =>
	Error.Log (Error.A_Previous_Error, Cuid, Puid, The_Variant);
	raise;

end Scan_Variant;
