------------------------------------------------------------------------------
--                                                                          --
--                          ASIStint COMPONENTS                             --
--                                                                          --
--                             A D D _ O N S                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Asis;
with Asis.Text;

package body Add_Ons is

------------------------------------------------------------------------------
-- Additional queries
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- Nil_*** queries
------------------------------------------------------------------------------

  function Nil_Compilation_Unit return Asis.Compilation_Unit is
  begin
    return Asis.Nil_Compilation_Unit;
  end;

  function Nil_Compilation_Unit_List return Asis.Compilation_Unit_List is
  begin
    return Asis.Nil_Compilation_Unit_List;
  end;


  function Nil_Element return Asis.Element is
  begin
    return Asis.Nil_Element;
  end;


  function Nil_Element_List return Asis.Element_List is
  begin
    return Asis.Nil_Element_List;
  end;


------------------------------------------------------------------------------
-- Queries to access Span fields
------------------------------------------------------------------------------

  function First_Line   (Sp: in Asis.Text.Span) return Integer is
  begin return Sp.First_Line; end First_Line;

  function First_Column (Sp: in Asis.Text.Span) return Integer is
  begin return Sp.First_Column; end First_Column;

  function Last_Line    (Sp: in Asis.Text.Span) return Integer is
  begin return Sp.Last_Line; end Last_Line;

  function Last_Column  (Sp: in Asis.Text.Span) return Integer is
  begin return Sp.Last_Column; end Last_Column;


------------------------------------------------------------------------------
-- Service queries
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- List handling
------------------------------------------------------------------------------

function Length (L : Asis.Element_List) return Integer is
begin
  return L'Last;
end Length;

function Length (L : Asis.Compilation_Unit_List) return Integer is
begin
  return L'Last;
end Length;

------------------------------------------------------------------------------
-- Wide_String handling
------------------------------------------------------------------------------

  function Concat (S1, S2: in Wide_String) return Wide_String is
  begin
    return S1 & S2;
  end Concat;

  function Eq     (S1, S2: in Wide_String) return Boolean is
  begin
    return S1 = S2;
  end Eq;

  function Lt     (S1, S2: in Wide_String) return Boolean is
  begin
    return S1 < S2;
  end Lt;

  function Gt     (S1, S2: in Wide_String) return Boolean is
  begin
    return S1 > S2;
  end Gt;

------------------------------------------------------------------------------
-- Integer handling
------------------------------------------------------------------------------

  function Add (I1, I2: in Integer) return Integer is
  begin
    return I1 + I2;
  end Add;

  function Sub (I1, I2: in Integer) return Integer is
  begin
    return I1 - I2;
  end Sub;

  function Eq  (I1, I2: in Integer) return Boolean is
  begin
    return I1 = I2;
  end Eq;

  function Lt  (I1, I2: in Integer) return Boolean is
  begin
    return I1 < I2;
  end Lt;

  function Gt  (I1, I2: in Integer) return Boolean is
  begin
    return I1 > I2;
  end Gt;

end Add_Ons;