------------------------------------------------------------------------------
--                                                                          --
--                          ASIStint COMPONENTS                             --
--                                                                          --
--                              A D D _ O N S                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Asis;
with Asis.Text;

package Add_Ons is

------------------------------------------------------------------------------
-- Additional queries
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- Nil_*** queries
------------------------------------------------------------------------------

  function Nil_Compilation_Unit      return Asis.Compilation_Unit;
  function Nil_Compilation_Unit_List return Asis.Compilation_Unit_List;
  function Nil_Element               return Asis.Element;
  function Nil_Element_List          return Asis.Element_List;

------------------------------------------------------------------------------
-- Queries to access Span fields
------------------------------------------------------------------------------

  function First_Line   (Sp: in Asis.Text.Span) return Integer;
  function First_Column (Sp: in Asis.Text.Span) return Integer;
  function Last_Line    (Sp: in Asis.Text.Span) return Integer;
  function Last_Column  (Sp: in Asis.Text.Span) return Integer;


------------------------------------------------------------------------------
-- Service queries
------------------------------------------------------------------------------

------------------------------------------------------------------------------
-- List handling
------------------------------------------------------------------------------

  function Length (L : Asis.Element_List) return Integer;
  function Length (L : Asis.Compilation_Unit_List) return Integer;

------------------------------------------------------------------------------
-- Wide_String handling
------------------------------------------------------------------------------

  function Concat (S1, S2: in Wide_String) return Wide_String;
  function Eq     (S1, S2: in Wide_String) return Boolean;
  function Lt     (S1, S2: in Wide_String) return Boolean;
  function Gt     (S1, S2: in Wide_String) return Boolean;

------------------------------------------------------------------------------
-- Integer handling
------------------------------------------------------------------------------

  function Add (I1, I2: in Integer) return Integer;
  function Sub (I1, I2: in Integer) return Integer;
  function Eq  (I1, I2: in Integer) return Boolean;
  function Lt  (I1, I2: in Integer) return Boolean;
  function Gt  (I1, I2: in Integer) return Boolean;

end Add_Ons;