------------------------------------------------------------------------------
--                                                                          --
--                          ASIStint COMPONENTS                             --
--                                                                          --
--           A S I S T I N T . A M B I G U O U S _ M A P P I N G            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIStint.Table; use ASIStint.Table;
with Funcenum;       use Funcenum;

package ASIStint.Ambiguous_Mapping is

------------------------------------------------------------------------------
-- Mapping of ambigious ASIS queries
------------------------------------------------------------------------------

  Type Amb_Index is (
    Corresponding_Body,
    Corresponding_Body_Stub,
    Corresponding_Children,
    Corresponding_Declaration,
    Corresponding_Parent_Declaration,
    Corresponding_Subunit,
    Corresponding_Subunit_Parent_Body,
    Corresponding_Type_Declaration,
    Debug_Image,
    Enclosing_Element,
    Exists,
    Is_Nil,
    Length,
    Subunits
    );
    -- All supported functions

  Type Amb_Node is record
    New_Index: Switch_Index;
    Synt:      Func_Syntax;
  end record;

  AI_LENGTH: constant Natural := 5;

  Amb_Info : array (Amb_Index, 1..AI_LENGTH) of Amb_Node := (
    (
      ( Corresponding_Body_CU_Ctx,
        (Par_CUnit, Par_CUnit, Par_Context, Par_Absent) ),
      ( Corresponding_Body_CU,
        (Par_CUnit, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Corresponding_Body_Ctx,
        (Par_Element, Par_Element, Par_Context, Par_Absent) ),
      ( Corresponding_Body,
        (Par_Element, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Body_Stub_Ctx,
        (Par_Element, Par_Element, Par_Context, Par_Absent) ),
      ( Corresponding_Body_Stub,
        (Par_Element, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Children_Ctx,
        (Par_CUnitList, Par_CUnit, Par_Context, Par_Absent) ),
      ( Corresponding_Children,
        (Par_CUnitList, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Declaration_CU_Ctx,
        (Par_CUnit, Par_CUnit, Par_Context, Par_Absent) ),
      ( Corresponding_Declaration_CU,
        (Par_CUnit, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Corresponding_Declaration_Ctx,
        (Par_Element, Par_Element, Par_Context, Par_Absent) ),
      ( Corresponding_Declaration,
        (Par_Element, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Parent_Declaration_Ctx,
        (Par_CUnit, Par_CUnit, Par_Context, Par_Absent) ),
      ( Corresponding_Parent_Declaration,
        (Par_CUnit, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Subunit_Ctx,
        (Par_Element, Par_Element, Par_Context, Par_Absent) ),
      ( Corresponding_Subunit,
        (Par_Element, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Subunit_Parent_Body_Ctx,
        (Par_CUnit, Par_CUnit, Par_Context, Par_Absent) ),
      ( Corresponding_Subunit_Parent_Body,
        (Par_CUnit, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Corresponding_Type_Declaration_Ctx,
        (Par_Element, Par_Element, Par_Context, Par_Absent) ),
      ( Corresponding_Type_Declaration,
        (Par_Element, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Debug_Image_Ctx,
        (Par_String, Par_Context, Par_Absent, Par_Absent) ),
      ( Debug_Image_CU,
        (Par_String, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Debug_Image,
        (Par_String, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Enclosing_Element_EEE,
        (Par_Element, Par_Element, Par_Element, Par_Absent) ),
      ( Enclosing_Element,
        (Par_Element, Par_Element, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Exists,
        (Par_Boolean, Par_Context, Par_Absent, Par_Absent)),
      ( Exists_CU,
        (Par_Boolean, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Is_Nil_CUL,
        (Par_Boolean, Par_CUnitList, Par_Absent, Par_Absent) ),
      ( Is_Nil_CU,
        (Par_Boolean, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Is_Nil_EL,
        (Par_Boolean, Par_ElemList, Par_Absent, Par_Absent) ),
      ( Is_Nil,
        (Par_Boolean, Par_Element, Par_Absent, Par_Absent) ),
      ( Is_Nil_Sp,
        (Par_Boolean, Par_Span, Par_Absent, Par_Absent) )
    ),

    (
      ( Length_CUL,
        (Par_Integer, Par_CUnitList, Par_Absent, Par_Absent) ),
      ( Length,
        (Par_Integer, Par_ElemList, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    ),

    (
      ( Subunits_Ctx,
        (Par_CUnitList, Par_CUnit, Par_Context, Par_Absent) ),
      ( Subunits,
        (Par_CUnitList, Par_CUnit, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) ),
      ( Invalid_Index,
        (Par_Absent, Par_Absent, Par_Absent, Par_Absent) )
    )

  );

end ASIStint.Ambiguous_Mapping;