------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                    A S I S T I N T . B A T C H _ I O                     --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIS; use ASIS;

with Ada.Strings.Wide_Fixed;  use Ada.Strings.Wide_Fixed;
with Ada.Characters.Handling; use Ada.Characters.Handling;

with ASIStint.String_Handling; use ASIStint.String_Handling;

with ASIStint.L_Parser; use ASIStint.L_Parser;
with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Call;     use ASIStint.Call;
with ASIStint.Get;      use ASIStint.Get;
with ASIStint.Text_IO;  use ASIStint.Text_IO;

with DeAlloc; use DeAlloc;

package body ASIStint.Batch_IO is

------------------------------------------------------------------------------
-- Logs and scripts interface
------------------------------------------------------------------------------

  procedure Script_IO (NP: Node_Position) is

    N: Node := CurStat.Tree(NP);

  begin

    case Identify_Function(NP) is
      when FT_EXECUTE | FT_RUN =>

        if N.NValue = 0
          then
          -- Resume current script
            if Script = 0 then
              Error(ERR_NOSCRIPT);
            end if;
            if not ScriptActive then
              ScriptActive:= True;
              CurTokStream := ScriptStream(Script);

            end if;
          else
          -- Initialize script
            N := CurStat.Tree(N.NValue);
            OpenScript(Get_String(N.NValue).All);
        end if;

      when FT_PAUSE =>
        if N.NValue = 0
          then
          -- Pause current script
            if Script = 0 then
              Error(ERR_NOSCRIPT);
            end if;
            if ScriptActive then
              ScriptActive:= False;
              ScriptStream(Script) := CurTokStream;
              CurTokStream.Text := null;
              Get_Next_Cmd;
            end if;
          else
            Error(ERR_BADPARAM);
        end if;

      when FT_EXIT =>
        if Script = 0 or not ScriptActive
        then
          Error(ERR_NOSCRIPT);
        end if;
        -- Deactivate current script
        CurTokStream.Cur_Token_Start := 0;
        
      when others => Error (ERR_INTERNAL);
    end case;

  end Script_IO;


  procedure Log_IO (NP: Node_Position) is

    N: Node := CurStat.Tree(NP);

  begin

    if N.NValue = 0
      then
      -- Close current log
        if Log then
            CloseLog;
          else
            Error(ERR_NEEDFILENAME);
        end if;
      else
      -- Open new log
        N := CurStat.Tree(N.NValue);
        OpenLog(Get_String(N.NValue).All);
    end if;

  end Log_IO;


  Cur_Line : Wide_String(1..100);


  procedure Get_Next_Cmd is

    Last: Integer;

  begin

    if Script > 0 and ScriptActive
    then
      CloseScript;
    end if;
    if Script = 0 or not ScriptActive then
      DeAlloc.Free(CurTokStream.Text);
      CurTokStream := (null, 1, 0, 0, 0);
      ATIPut(">", 3);
      ATIGet(Cur_Line, Last);
      Cur_Line(Last+1) := Nul_Char;
      CurTokStream.Text := new Wide_String (1..Last+1);
      Move( Cur_Line(1..Last+1), CurTokStream.Text.All );
--      To_Upper(CurTokStream.Text.All);
    end if;
  end Get_Next_Cmd;

end ASIStint.Batch_IO;