------------------------------------------------------------------------------
--                                                                          --
--                          ASIStint COMPONENTS                             --
--                                                                          --
--                        A S I S T I N T . C A L L                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIS;
with ASIS.Text;

with ASIStint.Common;   use ASIStint.Common;
with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Table;    use ASIStint.Table;
with ASIStint.XTable;   use ASIStint.XTable;

package ASIStint.Call is

------------------------------------------------------------------------------
-- Package for calling of ASIS queries; also provides a set of ASIStint
-- commands
------------------------------------------------------------------------------

  Type Function_Type is ( -- set of ASIStint commands
    FT_CALL,              -- (implicit) Call ASIS queries
    FT_EXECUTE,           -- Start/resume script
    FT_EXIT,              -- exit script
    FT_HELP,              -- General and query-specific help
    FT_IF,                -- Conditional operation
    FT_INFO,              -- ASIS and ASIStint tech info
    FT_LOG,               -- Start/end log
    FT_LOGLEVEL,       -- Set output level
    FT_PAUSE,             -- Pause script
    FT_PRINT,             -- Print variable value
    FT_QUIT,              -- Quit
    FT_RUN,               -- Start/resume script
    FT_SET                -- Set variable
  );

  type Parameter_Set is array (1..3) of Query_Result;

  function  Identify_Function (N: Node_Position)
    return Function_Type;
  -- Identifies ASIStint request

  function Call_ASIStint_Function (N: Wide_String; PS: Parameter_Set)
    return Query_Result;
  -- Calls ASIStint function Name with a parameter set PS

  function Save_ElemList  (E: Asis.Element_List) return ElemList_Ptr;
  function Save_CUnitList (C: Asis.Compilation_Unit_List) return CUnitList_Ptr;
  function Save_String    (S: Wide_String) return String_Ptr;

end ASIStint.Call;