------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                      A S I S T I N T . C O M M O N                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

package ASIStint.Common is

------------------------------------------------------------------------------
-- This package contains definitions common to ASIStint packages. By changing
-- some of the constants here, ASIStint flexibility can be adjusted.
------------------------------------------------------------------------------

  MAX_ID_LENGTH     : constant Positive := 32;
  -- The length of ASIStint identifier (may not be less than the longest
  -- name of ASIS query).


  MAX_VARIABLES     : constant Positive := 100;
  -- Size of initial ASIStint variable table; see ASIStint.Table


  MAX_TREENODES     : constant Positive := 500;
  -- Size of ASIStint statement trees; see ASIStint.S_Parser


  MAX_SCRIPTDEPTH   : constant Positive := 5;
  -- Depth of script enclosing; see ASIStint.Text_IO


  MAX_ATIELEMS      : constant Natural := 200;
  MAX_ATIELEMLISTS  : constant Natural := 100;
  MAX_ATICUNITS     : constant Natural := 100;
  MAX_ATICUNITLISTS : constant Natural := 10;
  MAX_ATICONTEXTS   : constant Natural := 10;
  MAX_ATISPANS      : constant Natural := 100;
  MAX_ATILINES      : constant Natural := 100;
  -- These constants define the size of ASIS support arrays declared
  -- in ASIStint.XTable


  ASISTINT_ERROR: exception;
  -- This exception is raised when ASIStint encounters a non-ASIS error;
  -- diagnosis of the type Error_Type is stored in LastErr

  ASISTINT_ASIS_ERROR: exception;
  -- This exception is raised when ASIStint encounters an ASIS error

  ASISTINT_LIGHT_ERROR: exception;
  -- This exception is raised when ASIStint encounters a non-critical
  -- error

  subtype Name_String is Wide_String (1..MAX_ID_LENGTH);
  -- Type to represent ASIStint IDs


  type String_Ptr is access all Wide_String;
  -- Used throughout ASIStint


  type Error_Type is (
    ERR_INTERNAL,
    ERR_NOTIMPLEMENTED,
    ERR_NOTSUPPORTED,

    ERR_NOSCRIPT,
    ERR_NEEDFILENAME,

    ERR_BADBOOLEAN,
    ERR_BADEXPR,
    ERR_BADID,
    ERR_BADINTEGER,
    ERR_BADLISTELEM,
    ERR_BADPARAM,
    ERR_BADPARAMLIST,
    ERR_BADSTRING,
    ERR_BADVARTYPE,
    ERR_NEEDCHAR,
    ERR_NEEDFUNCTION,
    ERR_NEEDPARAM,
    ERR_NOTINRANGE,
    ERR_TOOMANYPARAMS,
    ERR_UNKNOWNVAR,

    ERR_TABLEFULL,

    ERR_UNKNOWNSYNTAX,
    ERR_UNKNOWNQUERY
    );
    -- All possible errors


  LastErr: Error_Type;

  DebugPrint: Boolean := True;

  procedure Error (ErrNo:  Error_Type;
                   ErrStr: Wide_String  := "";
                   Level:  Natural := 5 );
  -- Debug output function
  pragma No_Return(Error);

end ASIStint.Common;