------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                        A S I S T I N T . E X E C                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIStint.Batch_IO; use ASIStint.Batch_IO;

with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Get;      use ASIStint.Get;
with ASIStint.Call;     use ASIStint.Call;
with ASIStint.Evaluate; use ASIStint.Evaluate;
with ASIStint.Help;
with ASIStint.If1;
with ASIStint.Print;
with ASIStint.Set;
with ASIStint.Table;    use ASIStint.Table;
with ASIStint.Text_IO;

package body ASIStint.Exec is

------------------------------------------------------------------------------
-- This package executes ASIStint commands
------------------------------------------------------------------------------

  procedure Exec_ATI_Command (N: Node_Position) is
    i: Integer;
  begin
    Exec_Result := -1;
    case Identify_Function(N) is
      when FT_INFO        => ASIStint.Help.ASISHelp;
      when FT_HELP        => ASIStint.Help.Help(N);

      when FT_CALL        =>
        declare
          QR: Query_Result := Evaluate_Node(N);
        begin
          if QR.RType /= Par_Absent then
            --PTI! Non-empty result is now ignored
            null;
          end if;
        end;

      when FT_IF          => ASIStint.If1.If1(N);
      when FT_SET         => ASIStint.Set.Set(N);

      when FT_LOGLEVEL =>
        if CurStat.Tree(N).NValue /= 0
          then -- Expect integer
            i := Get_Integer(CurStat.Tree(N+1).NValue);
            if i<0 or i>5 then
              Error(ERR_BADPARAM);
            end if;
            Text_IO.OutputLevel := i;
          else
            Error(ERR_NEEDPARAM);
        end if;

      when FT_LOG      => ASIStint.Batch_IO.Log_IO(N);
      when FT_RUN | FT_PAUSE
 | FT_EXIT
                       => ASIStint.Batch_IO.Script_IO(N);

      when FT_PRINT    => ASIStint.Print.Print(N);

      when FT_QUIT     =>
        if CurStat.Tree(N).NValue /= 0
          then -- Expect integer
            Exec_Result := Get_Integer(CurStat.Tree(N+1).NValue);
          else
            Exec_Result := 0;
        end if;
      when others      => null;
    end case;
  end Exec_ATI_Command;

end ASIStint.Exec;