------------------------------------------------------------------------------
--                                                                          --
--                          ASIStint COMPONENTS                             --
--                                                                          --
--                         A S I S T I N T . G E T                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Evaluate; use ASIStint.Evaluate;
with ASIStint.Table;    use ASIStint.Table;

package body ASIStint.Get is

------------------------------------------------------------------------------
-- This package provides retrieval of data from the ASIStint syntax tree
------------------------------------------------------------------------------

  function Get_String  ( N : Node_Position ) return String_Ptr is
    QR: Query_Result := Evaluate_Node(N);
  begin
    if QR.RType /= Par_String then
      Error(ERR_BADSTRING);
    end if;
    return QR.S;
  end Get_String;


  function Get_Integer ( N : Node_Position ) return Integer is
    QR: Query_Result := Evaluate_Node(N);
  begin
    if QR.RType /= Par_Integer then
      Error(ERR_BADINTEGER);
    end if;
    return QR.I;
  end Get_Integer;

end ASIStint.Get;