------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                        A S I S T I N T . H E L P                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIS;
     use ASIS;

with Asis.Implementation;

with ASIStint.Ambiguous_Mapping;
     use ASIStint.Ambiguous_Mapping;
with ASIStint.Common;
     use ASIStint.Common;
with ASIStint.S_Parser;
     use ASIStint.S_Parser;
with ASIStint.Table;
     use ASIStint.Table;
with ASIStint.String_Handling;
     use ASIStint.String_Handling;
with ASIStint.Text_IO;
     use ASIStint.Text_IO;

with funcenum; use funcenum;

package body ASIStint.Help is

------------------------------------------------------------------------------
-- ASIStint Help System
------------------------------------------------------------------------------

  procedure Display_Syntax (SW: Switch_Index; SYNT: Func_Syntax) is
  begin
    ATIPut("   "); ATIPut(Switch_Index'Wide_Image(SW));
    if SYNT(1)/=Par_Absent then
      ATIPut(" (");
    end if;
    for i in 1..3 loop
      exit when SYNT(i)=Par_Absent;
      if i/=1 then
        ATIPut(", ");
      end if;
      ATIPut(Skip_Prefix(Func_Param'Wide_Image(SYNT(i))));
    end loop;
    if SYNT(1) /= Par_Absent then
      ATIPut(")");
    end if;
    if SYNT(0) /= Par_Absent then
      ATIPut(" return ");
      ATIPut(Skip_Prefix(Func_Param'Wide_Image(SYNT(0))));
    end if;
    ATINew_Line;
  end Display_Syntax;


  procedure ASISHelp is
  -- ASIS and ASIStint tech info

  begin
    ATIPut_Line("ASIStint - ASIS Test Interpreter, v1.1");
    ATIPut_Line("(C) 1997, Free Software Foundation, Inc.");
    ATINew_Line;
    ATIPut_Line("ASIS and ASIStint Technical and Copyright Information:");
    ATINew_Line;
    ATIPut("  Asis Version:              ");
      ATIPut_Line(Asis.Implementation.Asis_Version);
    ATIPut("  Asis Implementor Version:  ");
      ATIPut_Line(Asis.Implementation.Asis_Implementor_Version);
    ATIPut("  Asis Implementor:          ");
      ATIPut_Line(Asis.Implementation.Asis_Implementor);
    ATIPut("  Asis Implementor Info:     ");
      ATIPut_Line(Asis.Implementation.Asis_Implementor_Information);
    ATINew_Line;
    ATIPut_Line("  ASIStint author Info:      Vasiliy Fofanov, ASIS-for-GNAT team");
    ATIPut_Line("                             --- Email: fofanov@bigfoot.com");
    ATIPut_Line("  ASIStint status:");
    if Log then
        ATIPut_Line("          Log enabled. Output Level: "
                    & Integer'Wide_Image(OutputLevel));
      else
        ATIPut_Line("          Log disabled.");
    end if;
    if Script>0 then
        ATIPut("          Script enabled (level "
               & Integer'Wide_Image(Script) & ") ");
        if ScriptActive then
            ATIPut_Line("and running.");
          else
            ATIPut_Line("and paused.");
        end if;
      else
        ATIPut_Line("          Script disabled.");
    end if;
  end;


  procedure Help (NP: Node_Position) is
  -- Help system

    T:  Func_Syntax;
    sw: Switch_Index;
    Amb:Amb_Index;
    N:  Node := CurStat.Tree(NP);

  begin

    ATINew_Line;

    if N.NValue = 0
      then
      -- General help
        ATIPut_Line("ASIStint - ASIS Test Interpreter, v2.0");
        ATIPut_Line("(C) 1997, Free Software Foundation, Inc.");
        ATIPut("  Asis Version: ");
        ATIPut_Line(Asis.Implementation.Asis_Version);
        ATINew_Line;
        ATIPut_Line("List of ASIStint utilities:");
        ATINew_Line;
        ATIPut_Line("  EXIT                    Exits the current script");
        ATIPut_Line("  HELP (<query-name>)     Displays a syntax of an ASIS query <query-name>");
        ATIPut_Line("  IF (<bool-expr>,<expr1>[,<expr2>]) Executes <expr1> if <bool-expr> is true,");
        ATIPut_Line("                                     otherwise, executes <expr2> if present");
        ATIPut_Line("  INFO                    Displays ASIS and ASIStint technical info");
        ATIPut_Line("  LOG [(""<filename>"")]    Opens file as a current log/closes current log");
        ATIPut_Line("  LOGLEVEL (<level>)      Sets a logging level to integer <level>,0..5");
        ATIPut_Line("  PAUSE                   Pauses current script");
        ATIPut_Line("  PRINT (<variable>)      Prints a value of a variable");
        ATIPut_Line("  QUIT [(<exit-status>)]  Exits program returning <exit-status> or 0");
        ATIPut_Line("  RUN [(""<filename>"")]    Launches script <filename>/resumes paused script");
        ATIPut_Line("  SET ( <ID>, <expr> )    Declares or changes variable <ID>");
        ATINew_Line;
        ATIPut_Line("Please refer to ASIStint User's Guide for more information.");
      else
      -- ASIS queries help
        N := CurStat.Tree(N.NValue);
        -- receive parameter list
        N := CurStat.Tree(N.NValue);
        -- receive first element
        sw := Switch_Index'Wide_Value(N.SValue.All);
        for i in Switch_Info'Range loop
          if sw in Switch_Info(i).From .. Switch_Info(i).To then
            T := Switch_Info(i).Synt;
            exit;
          end if;
        end loop;
        ATIPut("Help on ASIS query: ");
        ATIPut_Line(N.SValue.All);
        ATIPut_Line("Query syntax:");
        begin
          Amb := Amb_Index'Value(Switch_Index'Image(sw));
          for i in 1..AI_LENGTH loop
            exit when Amb_Info(Amb, i).New_Index = Invalid_Index;
            Display_Syntax(sw, Amb_Info(Amb, i).Synt);
          end loop;
        exception
          when CONSTRAINT_ERROR => Display_Syntax(sw, T);
        end;

    end if;
    exception
      when CONSTRAINT_ERROR=>
        Error(ERR_UNKNOWNQUERY, N.SValue.All);
  end Help;

end ASIStint.Help;