------------------------------------------------------------------------------
--                                                                          --
--                          ASIStint COMPONENTS                             --
--                                                                          --
--                        A S I S T I N T . I F 1                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Ada.Strings;
     use Ada.Strings;
with Ada.Strings.Wide_Fixed;
     use Ada.Strings.Wide_Fixed;

with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Exec;     use ASIStint.Exec;
with ASIStint.Evaluate; use ASIStint.Evaluate;
with ASIStint.Table;    use ASIStint.Table;

with funcenum;
     use funcenum;

package body ASIStint.If1 is

------------------------------------------------------------------------------
-- Package for ASIStint conditional operation
------------------------------------------------------------------------------

  procedure If1 (N: Node_Position) is

    NPtr1, NPtr2, NPtr3: Node_Position;
    VI:    Var_Info;
    QR:    Query_Result;
  begin

    if CurStat.Tree(N).NValue = 0 then
      Error(ERR_NEEDPARAM);
    end if;

    NPtr1 := CurStat.Tree(N).NValue;

    if CurStat.Tree(NPtr1).Next_Node = 0 then
      Error(ERR_NEEDPARAM);
    end if;

    NPtr2 := CurStat.Tree(NPtr1).Next_Node;
    NPtr3 := CurStat.Tree(NPtr2).Next_Node;

    NPtr1 := CurStat.Tree(NPtr1).NValue;   -- condition
    NPtr2 := CurStat.Tree(NPtr2).NValue;   -- <THEN> ATI command

    if NPtr3 /= 0 then
        -- <ELSE> ATI command
        NPtr3 := CurStat.Tree(NPtr3).NValue;   -- condition
        if CurStat.Tree(NPtr3).Next_Node /= 0 then
        -- Only 1 or 2 branches allowed
          Error(ERR_TOOMANYPARAMS);
        end if;
      else
        NPtr3 := 0;
    end if;

    QR := Evaluate_Node(NPtr1);

    if QR.RType /= Par_Boolean then
      Error(ERR_BADBOOLEAN);
    end if;

    if QR.B then
        Exec_ATI_Command (NPtr2);
      else
        Exec_ATI_Command (NPtr3);
    end if;

  end If1;

end ASIStint.If1;