------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                       A S I S T I N T . P R I N T                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIS; use ASIS;

with Asis.Elements;
with Asis.Ada_Environments;
with Asis.Compilation_Units;
with Asis.Text;

with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Call;     use ASIStint.Call;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Table;    use ASIStint.Table;
with ASIStint.XTable;   use ASIStint.XTable;
with ASIStint.Text_IO;  use ASIStint.Text_IO;
with ASIStint.Evaluate; use ASIStint.Evaluate;

with funcenum; use funcenum;

package body ASIStint.Print is

------------------------------------------------------------------------------
-- This package provides printing of the ASIStint variables
------------------------------------------------------------------------------

  procedure Print_Result ( QR : Query_Result) is
  begin
    case QR.RType is

      when Par_Absent   =>
        Error(ERR_BADPARAM);

      when Par_Boolean    =>
        ATIPut_Line(Boolean'Wide_Image(QR.B));

      when Par_CUnit   =>
        begin
          ATIPut_Line(Asis.Compilation_Units.Debug_Image(QR.C));
        exception
          when others => Error(ERR_INTERNAL, "CUnits.Debug_Image failed");
        end;

      when Par_CUnitList =>
        ATIPut("CUnitList size:");
        ATIPut_Line(Integer'Wide_Image(QR.CL.All'Length));
        for i in QR.CL.All'Range loop
          begin
            ATIPut_Line(Asis.Compilation_Units.Debug_Image(QR.CL.All(i)) );
          exception
            when others => Error(ERR_INTERNAL, "CUnits.Debug_Image failed");
          end;
        end loop;

      when Par_Element =>
        begin
          ATIPut_Line(Asis.Elements.Debug_Image(QR.E));
        exception
          when others => Error(ERR_INTERNAL, "Elements.Debug_Image failed");
        end;

      when Par_ElemList =>
        ATIPut("ElemList size:");
        ATIPut_Line(Integer'Wide_Image(QR.EL.All'Length));
        for i in QR.EL.All'Range loop
          begin
            ATIPut_Line(Elements.Debug_Image(QR.EL.All(i)) );
          exception
            when others => Error(ERR_INTERNAL, "Elements.Debug_Image failed");
          end;
        end loop;

      when Par_Integer =>
        ATIPut_Line(Integer'Wide_Image(QR.I));

      when Par_Context =>
        ATIPut_Line(Asis.Ada_Environments.Debug_Image(ATIContext(QR.I)));

      when Par_String  =>
        ATIPut_Line(QR.S.All);

--PTI!     when Par_Span    =>
--PTI!       ATIPut_Line(Asis.Text.Debug_Image(QR.Sp));

      when others => Error(ERR_BADPARAM);
    end case;
  exception
    when others =>
      Error(ERR_INTERNAL,"Print_Result");
  end Print_Result;


  procedure Print (N: Node_Position) is

    NPtr: Node_Position;

  begin
    if CurStat.Tree(N).NValue = 0 then
      Error(ERR_NEEDPARAM);
    end if;

    NPtr := CurStat.Tree(N).NValue; -- NT_PARAMLIST

    if CurStat.Tree(NPtr).Next_Node /= 0 then
      Error(ERR_TOOMANYPARAMS);
    end if;

    NPtr := CurStat.Tree(NPtr).NValue; -- Parameter of Print

    Print_Result(Evaluate_Node(NPtr));
  end Print;

end ASIStint.Print;