------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                    A S I S T I N T . S _ P A R S E R                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Table;    use ASIStint.Table;
with ASIStint.L_Parser; use ASIStint.L_Parser;

package ASIStint.S_Parser is

------------------------------------------------------------------------------
-- This package provides parsing for the ASIStint language
------------------------------------------------------------------------------

  type Node_Type is (
    NT_BOOLEAN,
    NT_FUNCTION,
    NT_INTEGER,
    NT_PARAMLIST,
    NT_STRING,
    NT_VARIABLE
  );

  subtype Node_Position is Natural range 0..MAX_TREENODES;

  type Node is
    record
      NType     : Node_Type;
      VType     : Var_Type;
      SValue    : String_Ptr;
      IValue    : Integer;
      NValue    : Node_Position;
      Next_Node : Node_Position;
    end record;

  type TStorage is array (Node_Position) of Node;

  type Statement_Tree is
    record
      Free      : Node_Position:= 1;
      Tree      : TStorage;
    end record;

  CurStat: Statement_Tree;

  procedure Reset_Tree;
  procedure Get_Func (TS : in out Token_Stream);
  procedure Get_Expr (TS : in out Token_Stream);
  procedure Get_Stmt (TS : in out Token_Stream);

end ASIStint.S_Parser;