------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                         A S I S T I N T . S E T                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Ada.Strings;
     use Ada.Strings;
with Ada.Strings.Wide_Fixed;
     use Ada.Strings.Wide_Fixed;

with ASIS; use ASIS;
with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.Call;     use ASIStint.Call;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Get;      use ASIStint.Get;
with ASIStint.Table;    use ASIStint.Table;
with ASIStint.XTable;   use ASIStint.XTable;
with ASIStint.Text_IO;  use ASIStint.Text_IO;
with ASIStint.Evaluate; use ASIStint.Evaluate;

with funcenum; use funcenum;

package body ASIStint.Set is

------------------------------------------------------------------------------
-- Package for declaration and changing of ASIStint variables
------------------------------------------------------------------------------

  function Build_Var ( Name : Wide_String; VI : Var_Info) return Var_Info is

    VI1: Var_Info;

  begin

    VI1 := VI;
    Move(Name, VI1.Name, Right);

    case VI.VType is

      when Par_Absent   =>
        Error(ERR_BADPARAM);

      when Par_CUnit   =>
        ATICUnit(ATICUnitFree) := ATICUnit(VI.IValue);
        VI1.IValue := ATICUnitFree;
        ATICUnitFree := ATICUnitFree + 1;

      when Par_CUnitList =>
        ATICUnitList(ATICUnitListFree) := ATICUnitList(VI.IValue);
        ATICUnitList(0) := null;
        VI1.IValue := ATICUnitListFree;
        ATICUnitListFree := ATICUnitListFree + 1;

      when Par_Element =>
        ATIElem(ATIElemFree) := ATIElem(VI.IValue);
        VI1.IValue := ATIElemFree;
        ATIElemFree := ATIElemFree + 1;

      when Par_ElemList =>
        ATIElemList(ATIElemListFree) := ATIElemList(VI.IValue);
        ATIElemList(0) := null;
        VI1.IValue := ATIElemListFree;
        ATIElemListFree := ATIElemListFree + 1;

      when Par_Span    =>
        ATISpan(ATISpanFree) := ATISpan(VI.IValue);
        VI1.IValue := ATISpanFree;
        ATISpanFree := ATISpanFree + 1;

      when others => null;
    end case;

    return VI1;

    exception
      when CONSTRAINT_ERROR => -- ASIS types arrays overflow
        Error(ERR_TABLEFULL);

  end Build_Var;


  procedure Set (N: Node_Position) is

    NPtrV, NPtrE: Node_Position;
    VI:    Var_Info;
    QR:    Query_Result;

  begin

    if CurStat.Tree(N).NValue = 0 then
      Error(ERR_NEEDPARAM);
    end if;

    NPtrV := CurStat.Tree(N).NValue;

    if CurStat.Tree(NPtrV).Next_Node = 0 then
    -- Create a Context variable
      NPtrV := CurStat.Tree(NPtrV).NValue;
      Move(CurStat.Tree(NPtrV).SValue.All, VI.Name, Right);
      VI.VType    := Par_Context;
      VI.IValue   := ATIContextFree;
      ATIContextFree := ATIContextFree + 1;
      Modify_Var(CurTable, VI);
      return;
    end if;

    NPtrE := CurStat.Tree(NPtrV).Next_Node;

    if CurStat.Tree(NPtrE).Next_Node /= 0 then
    -- Only 1 or 2 parameters allowed
      Error(ERR_TOOMANYPARAMS);
    end if;

    NPtrV := CurStat.Tree(NPtrV).NValue;   -- variable name
    NPtrE := CurStat.Tree(NPtrE).NValue;   -- expression

    if CurStat.Tree(NPtrV).NType /= NT_VARIABLE then
      Error(ERR_BADPARAM);
    end if;

    QR := Evaluate_Node(NPtrE);

    VI := Build_Var(CurStat.Tree(NPtrV).SValue.All, Store_Var_Value(QR));

    Modify_Var(CurTable, VI);

  end Set;

end ASIStint.Set;