------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--             A S I S T I N T . S T R I N G _ H A N D L I N G              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Ada.Characters.Handling; use  Ada.Characters.Handling;
with ASIStint.Common; use ASIStint.Common;

package body ASIStint.String_Handling is

------------------------------------------------------------------------------
-- Low-level string analysis
------------------------------------------------------------------------------

  function Word_End (Str: in Wide_String; ID: in Boolean:=FALSE)
      return Integer is
    P: Integer:= Str'Last;
  begin
    for i in Str'First..Str'Last loop
      if ID and (Str(i) in 'A'..'Z' or Str(i) in 'a'..'z' or Str(i)='_' or
        Str(i) in '0'..'9') then P:= i; else exit; end if;
      if Str(i)/=' ' then P:= i; else exit; end if;
    end loop;
    return P;
  end Word_End;


  function Skip_Spc (Str: in Wide_String) return Integer is
  begin
    for i in Str'First..Str'Last loop
        if Str(i)/=' ' then
          return i;
        end if;
    end loop;
    return Str'Last;
  end Skip_Spc;


  function Skip_Symbol (Str: in Wide_String; C: in Wide_Character)
      return Integer is
    P: Integer;
  begin
    P:= Skip_Spc(Str);
    if P>0 and Str(P)=C then P:=P+1; else P:=0; end if;
    return P;
  end Skip_Symbol;


  function Skip_Prefix (S: in Wide_String; N: in Natural := 4)
    return Wide_String is
  begin
    return S(N+1..S'Last);
  end Skip_Prefix;


  function Find_Symbol (Str: in Wide_String; C: in Wide_Character)
      return Integer is
    P: Integer := Str'First;
  begin
    while P<=Str'Last loop
      if Str(P)=C then
          return P;
        else
          P:=P+1;
      end if;
    end loop;
    return 0;
  end Find_Symbol;


  procedure Read_Integer (S: in Wide_String; Val, New1st: out Integer) is
  begin
    New1st := S'First; Val := 0;
    while S(New1st) in '0'..'9' loop
      Val:=Val*10 + Wide_Character'Pos(S(New1st))-Wide_Character'Pos('0');
      New1st:= New1st+1;
      exit when New1st>S'Last;
    end loop;
  end Read_Integer;

  procedure To_Upper (S: in out Wide_String) is
    i: Natural := S'First;
  begin
    loop
      exit when i > S'Last;
      if S(i) in 'a'..'z'
        then S(i) := To_Wide_Character(To_Upper(To_Character(S(i))));
        elsif S(i) = '"'
          then
            i := Find_Symbol(S(i+1..S'Last), '"');
            if i = 0 then
              Error(ERR_BADSTRING);
            end if;
            i := i+1;
      end if;
      i := i+1;
    end loop;
  end To_Upper;

end ASIStint.String_Handling;