------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                     A S I S T I N T . T E X T _ I O                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Ada.Characters.Handling;
with Ada.Wide_Text_IO;  use Ada.Wide_Text_IO;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.L_Parser; use ASIStint.L_Parser;

package ASIStint.Text_IO is

------------------------------------------------------------------------------
-- Text I/O supporting scripts and logs
------------------------------------------------------------------------------

  OutputLevel:  Integer:= 1;
-- Output Level can be 0 through 5 and is changed with LOGLEVEL command.
-- All output with level of not less then OutputLevel is sent to current
-- log, all other is only displayed. Output Levels (default is 5):
-- Level 5 (always sent to log): ASIS exception handlers; PRINT output.
-- Level 4: Monitor warnings.
-- Level 3: Monitor standard messages.
-- Level 2: Command prompt; input backup.
-- Level 0: Internal debugging information.
-- ASIStint keeps track of all I/O throughout the session in the file
-- SESSION.LOG. OutputLevel is ignored for this file and all level 0
-- output will be recorded. Therefore, it is not recommended to set
-- OutputLevel to 0

  procedure ATIGet      (S: out Wide_String; Last: out Integer);
  procedure ATIPut      (S: in  Wide_String; Level: in Integer:= 5);
  procedure ATINew_Line (Level: in Integer:= 5);
  procedure ATIPut_Line (S: in Wide_String; Level: in Integer:= 5);
  procedure ATIPut      (I: Integer; Level: in Integer:= 5);

  procedure OpenScript   (S: in Wide_String);
  procedure CloseScript;
  procedure OpenLog (S: in Wide_String);
  procedure CloseLog;

  Script:       Natural := 0;
  ScriptActive: Boolean := FALSE;
  ScriptStream: array (1..MAX_SCRIPTDEPTH) of Token_Stream;
  ScriptActivity: array (1..MAX_SCRIPTDEPTH) of Boolean;
  Log:          Boolean := FALSE;
  LogFD:        File_Type;

  Nul_Char:     Wide_Character :=
    Ada.Characters.Handling.To_Wide_Character(Ascii.Nul);

end ASIStint.Text_IO;