------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                      A S I S T I N T . X T A B L E                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with ASIS.Text;
with ASIStint.Common;
     use ASIStint.Common;

package ASIStint.XTable is

------------------------------------------------------------------------------
-- This package adds ASIS types support to ASIStint variable tables
------------------------------------------------------------------------------

  type ElemList_Ptr  is access all Asis.Element_List;
  type CUnitList_Ptr is access all Asis.Compilation_Unit_List;

  ATIElem     : array (0..MAX_ATIELEMS)
                of Asis.Element;
  ATIElemList : array (0..MAX_ATIELEMLISTS)
                of ElemList_Ptr:= (0..MAX_ATIELEMLISTS => null);
  ATICUnit    : array (0..MAX_ATICUNITS)
                of Asis.Compilation_Unit;
  ATICUnitList: array (0..MAX_ATICUNITLISTS)
                of CUnitList_Ptr:= (0..MAX_ATICUNITLISTS => null);
  ATIContext  : array (0..MAX_ATICONTEXTS)
                of Asis.Context;
  ATISpan     : array (0..MAX_ATISPANS)
                of Asis.Text.Span;
  ATILine     : array (0..MAX_ATILINES)
                of Asis.Text.Line;
  -- These arrays will contain the user defined variables of ASIS types
  -- See package ASIStint.Common for the definitions of the above constants

  ATIElemFree      : Natural :=1;
  ATIElemListFree  : Natural :=1;
  ATICUnitFree     : Natural :=1;
  ATICUnitListFree : Natural :=1;
  ATIContextFree   : Natural :=1;
  ATISpanFree      : Natural :=1;
  ATILineFree      : Natural :=1;
  -- Positions of the first free element in arrays.
  -- Note that the 0th position is used for internal purposes.



--PTI  type State is record
--PTI    ATIElemFree      : Natural;
--PTI    ATIElemListFree  : Natural;
--PTI    ATICUnitFree     : Natural;
--PTI    ATICUnitListFree : Natural;
--PTI    ATIContextFree   : Natural;
--PTI    ATISpanFree      : Natural;
--PTI    ATILineFree      : Natural;
--PTI  end;
--PTI  -- Positions of the first free element in arrays.
--PTI
--PTI  Cur_State: State := (1, 1, 1, 1, 1, 1, 1 );
--PTI  -- Current state of the arrays; note that the 0th position is used
--PTI  -- for internal purposes

end ASIStint.XTable;