------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                             A S I S T I N T                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Ada.Exceptions;
with Ada.Characters.Handling; use Ada.Characters.Handling;

with Asis.Implementation;

with ASIStint.Text_IO;  use ASIStint.Text_IO;
with ASIStint.Batch_IO; use ASIStint.Batch_IO;

with ASIStint.S_Parser; use ASIStint.S_Parser;
with ASIStint.L_Parser; use ASIStint.L_Parser;
with ASIStint.Common;   use ASIStint.Common;
with ASIStint.Exec;     use ASIStint.Exec;

package body ASIStint is

------------------------------------------------------------------------------
-- This package is an upper-level interface to ASIStint
------------------------------------------------------------------------------

  function Parse_Cmd_Line (ScriptName : Wide_String := "" ) return Integer is
    I, J: Integer;
  begin

    ATIPut_Line("ASIStint - ASIS Test Interpreter, v2.0");
    ATIPut_Line("(C) 1997, Free Software Foundation, Inc.");
    ATIPut("  Asis Version: ");
    ATIPut_Line(Asis.Implementation.Asis_Version);
    ATINew_Line;

    if ScriptName'Length > 0 then
        OpenScript(ScriptName);
      else
        Get_Next_Cmd;
    end if;

    loop
     begin

      if not Is_Active(CurTokStream) then
        Get_Next_Cmd;
      end if;

      Reset_Tree;

      I := CurTokStream.Cur_Token_Start;
      Get_Stmt(CurTokStream);
      J := CurTokStream.Cur_Token_Start-1;
      if I>J then
        J := CurTokStream.Text'Last;
      end if;

      if ScriptActive then
          ATIPut(CurTokStream.Text(I..J), 2);
        else
          ATIPut(CurTokStream.Text(I..J), 0);
      end if;

      if CurStat.Free > 1 then
        Exec_ATI_Command(1);
        if Exec_Result /= -1 then
          return Exec_Result;
        end if;
      end if;
      exception
       when ASISTINT_ASIS_ERROR | ASISTINT_LIGHT_ERROR =>
         -- just a trap; all handling is done in other packages
         null;
       when ASISTINT_ERROR =>
         --  Purge script if active, otherwise purge command line
         if ScriptActive then
             CloseScript;
           else
             CurTokStream.Cur_Token_Start := 0;
         end if;
       when E: others =>
         ATIPut_Line("Raised unhandled exception " &
                     To_Wide_String(Ada.Exceptions.Exception_Name(E)), 5);
         --  Purge script if active, otherwise purge command line
         if ScriptActive then
             CloseScript;
           else
             CurTokStream.Cur_Token_Start := 0;
         end if;
     end;
    end loop;

  end Parse_Cmd_Line;

end ASIStint;