------------------------------------------------------------------------------
--                                                                          --
--                           ASIStint COMPONENTS                            --
--                                                                          --
--                            F U N C T Y P E S                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1997, Free Software Foundation, Inc.            --
--                                                                          --
-- ASIStint is free software; you can redistribute  it  and/or  modify  it  --
-- under terms of the GNU General Public License  as published by the  Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version.  ASIStint  is distributed  in the hope  that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;  without even the implied warranty of  MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU General Public License  distributed with ASIStint; see file COPYING. --
-- If not, write to the  Free  Software  Foundation,  59 Temple Place Suite --
-- 330, Boston, MA 02111-1307, USA.                                         --
--                                                                          --
-- ASIStint  was  originally  developed  by  the  ASIS-for-GNAT team at the --
-- Software Engineering  Laboratory  of  the  Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne, Switzerland, in cooperation with  the --
-- Scientific  Research  Computer  Center  of Moscow State University (SRCC --
-- MSU), Russia.                                                            --
--                                                                          --
-- This work was supported by a  grant  from  the  Swiss  National  Science --
-- Foundation, no 7SUPJ048247, funding a project entitled  "Development  of --
-- ASIS for GNAT with industry quality".                                    --
------------------------------------------------------------------------------

with Asis;
with Asis.Text;
with Ada.Calendar;

package FuncTypes is

------------------------------------------------------------------------------
-- Definitions of accesses to various ASIS queries
------------------------------------------------------------------------------

type CtxRetBool is access
    function (Context: in Asis.Context)
      return Boolean;

type CtxRetCUnitList is access
    function (Context: in Asis.Context)
      return Asis.Compilation_Unit_List;

type CtxRetElemList is access
    function (Context: in Asis.Context)
      return Asis.Element_List;

type CtxRetNull is access
    procedure(Context: in out Asis.Context);

type CtxRetString is access
    function (Context: in Asis.Context)
      return Wide_String;

type CtxStringStringRetNull is access
    procedure(Context: in out Asis.Context; Str1, Str2: Wide_String);

type CUnitBoolRetElemList is access
    function (CUnit: in Asis.Compilation_Unit; Bool : in Boolean)
      return Asis.Element_List;

type CUnitCtxRetCUnit is access
    function (CUnit  : in Asis.Compilation_Unit;
              Context: in Asis.Context)
      return Asis.Compilation_Unit;

type CUnitCtxRetCUnitList is access
    function (CUnit  : in Asis.Compilation_Unit;
              Context: in Asis.Context)
      return Asis.Compilation_Unit_List;

type CUnitCUnitRetBool is access
    function (CUnit1, CUnit2: in Asis.Compilation_Unit)
      return Boolean;

type CUnitListRetBool is access
    function (CUnit: in Asis.Compilation_Unit_List)
      return Boolean;

type CUnitListRetInt is access
    function (CUnit: in Asis.Compilation_Unit_List)
      return Integer;

type CUnitRetBool is access
    function (CUnit: in Asis.Compilation_Unit)
      return Boolean;

type CUnitRetCtx is access
    function (CUnit: in Asis.Compilation_Unit)
      return Asis.Context;

type CUnitRetCUnit is access
    function (CUnit: in Asis.Compilation_Unit)
      return Asis.Compilation_Unit;

type CUnitRetCUnitList is access
    function (CUnit: in Asis.Compilation_Unit)
      return Asis.Compilation_Unit_List;

type CUnitRetElem is access
    function (CUnit: in Asis.Compilation_Unit)
      return Asis.Element;

type CUnitRetElemList is access
    function (CUnit: in Asis.Compilation_Unit)
      return Asis.Element_List;

type CUnitRetString is access
    function (CUnit: in Asis.Compilation_Unit)
      return Wide_String;

type CUnitStringRetBool is access
    function (CUnit: in Asis.Compilation_Unit; Str: in Wide_String)
      return Boolean;

type CUnitStringRetString is access
    function (CUnit: in Asis.Compilation_Unit; Str: in Wide_String)
      return Wide_String;

type ElemBoolRetElemList is access
    function (Element: in Asis.Element; Bool: in Boolean)
      return Asis.Element_List;

type ElemCtxRetElem is access
    function (Element: in Asis.Element; Context: in Asis.Context)
      return Asis.Element;

type ElemElemBoolRetBool is access
    function (Element1, Element2: in Asis.Element; Bool: in Boolean)
      return Boolean;

type ElemElemBoolRetElemList is access
    function (Element1, Element2: in Asis.Element; Bool: in Boolean)
      return Asis.Element_List;

type ElemElemRetElem is access
    function (Element1, Element2 : in Asis.Element)
      return Asis.Element;

type ElemListRetBool is access
    function (ElemList : in Asis.Element_List)
      return Boolean;

type ElemListRetInt is access
    function (ElemList : in Asis.Element_List)
      return Integer;

type ElemRetBool is access
    function (Element : in Asis.Element)
      return Boolean;

type ElemRetCUnit is access
    function (Element: in Asis.Element)
      return Asis.Compilation_Unit;

type ElemRetElem is access
    function (Element : in Asis.Element)
      return Asis.Element;

type ElemRetElemList is access
    function (Element: in Asis.Element)
      return Asis.Element_List;

type ElemRetInt is access
    function (Element: in Asis.Element)
      return Integer;

type ElemRetSpan is access
    function (Element: in Asis.Element)
      return Asis.Text.Span;

type ElemRetString is access
    function (Element: in Asis.Element)
      return Wide_String;

type IntIntRetBool is access
    function (I1, I2: in Integer)
      return Boolean;

type IntIntRetInt is access
    function (I1, I2: in Integer)
      return Integer;

type RetBool is access
    function
      return Boolean;

type RetCUnit is access
    function
      return Asis.Compilation_Unit;

type RetCUnitList is access
    function
      return Asis.Compilation_Unit_List;

type RetElem is access
    function
      return Asis.Element;

type RetElemList is access
    function
      return Asis.Element_List;

type RetSpan is access
    function
      return Asis.Text.Span;

type RetString is access
    function
      return Wide_String;

type SpanRetBool is access
    function (Span: in Asis.Text.Span)
      return Boolean;

type SpanRetInt is access
    function (Span: in Asis.Text.Span)
      return Integer;

type StringCtxRetCUnit is access
    function (Str: in Wide_String; Context: in Asis.Context)
      return Asis.Compilation_Unit;

type StringRetNull is access
    procedure(Str : in Wide_String);

type StringStringRetBool is access
    function (S1, S2: in Wide_String)
      return Boolean;

type StringStringRetString is access
    function (S1, S2: in Wide_String)
      return Wide_String;

end FuncTypes;