with Asis;
with Asis.Compilation_Units;
with Asis.Elements;
with Asis.Declarations;
with Asis.Iterator;
with Text_Io;

package body Declaration_Counts is

    procedure Process_Element (Elem : in Asis.Element;
                               Control : in out Asis.Traverse_Control;
                               The_Counts : in out Count_T);

    procedure No_Op (Elem : in Asis.Element;
                     Control : in out Asis.Traverse_Control;
                     The_Counts : in out Count_T);

    procedure Count_Decls is new Asis.Iterator.Traverse_Element
                               (Count_T, Process_Element, No_Op);

Procedure Count (CU : Asis.Compilation_Unit;
                 The_Counts : in out Count_T) is
    Control : Asis.Traverse_Control := Asis.Continue;
begin
    Text_Io.Put_Line("Processing " &
           Asis.Unit_Kinds'Image (Asis.Compilation_Units.Unit_Kind(CU)) &
           ": " &
           Asis.Compilation_Units.Unit_Full_Name(CU));

    Count_Decls(Asis.Elements.Unit_Declaration (CU), 
                       Control, The_Counts);
end;

Procedure Output_Counts (The_Counts : Count_T) is
begin
    Text_Io.Put_Line("Declaration_Kind   Count");
    For I in Asis.Declaration_Kinds loop
       Text_io.Put_line( Asis.Declaration_Kinds'Image(I) 
          & ":" & Integer'Image (The_Counts.Count(I)) );
    end loop;
end;

procedure No_Op (Elem : in Asis.Element;
                 Control : in out Asis.Traverse_Control;
                 The_Counts : in out Count_T) is
begin
    null;
end;

procedure Process_Element (Elem : in Asis.Element;
                               Control : in out Asis.Traverse_Control;
                               The_Counts : in out Count_T) is
    
        Decl_Kind : Asis.Declaration_Kinds :=
             Asis.Elements.Declaration_Kind (Elem);
    begin
        case Decl_Kind is
           when Asis.Not_A_Declaration =>
               null;
           when others =>
              declare
                  Name_List : Asis.Defining_Name_List 
                      := Asis.Declarations.Names (Elem);
              begin
                 The_Counts.Count (Decl_Kind) := The_Counts.Count (Decl_Kind)
                                          + Name_List'Length;
              end;
        end case;
    end Process_Element;

end Declaration_Counts;





