with Asis;
with Asis.Implementation;
with Asis.Ada_Environments;
with Unit_Processing_Templates;
with Declaration_Counts;

procedure template_app_example is
    My_Context : Asis.Context;
    procedure Count_Decls is new 
      Unit_Processing_Templates.Process_Application_Units
        ( Result_T => Declaration_Counts.Count_T,
          Process => Declaration_Counts.Count,
          Post_Process => Declaration_Counts.Output_Counts );

begin
    Asis.Implementation.Initialize(String'("T"));
    Asis.Ada_Environments.Associate (My_Context,String'(""));
    Asis.Ada_Environments.Open (My_Context);

    Count_Decls ( My_Context );

    Asis.Ada_Environments.Close (My_Context);
    Asis.Ada_Environments.Dissociate (My_Context);
    Asis.Implementation.Finalize(String'(""));
end template_app_example;
