with Asis;
with Asis.Compilation_Units;

package body Unit_Processing_Templates is

procedure Process_Application_Units (Context : Asis.Context ) is
    Results : Result_T;
    Unit_List : Asis.Compilation_Unit_List :=       
         Asis.Compilation_Units.Compilation_Units (Context); 

begin
    for I in Unit_List'Range loop
        case Asis.Compilation_Units.Unit_Origin (Unit_List (I)) is
           when Asis.An_Application_Unit =>
                Process (Unit_List (I), Results);
           when others => null;
        end case;
    end loop;
    Post_Process (Results);
end Process_Application_Units;

procedure Process_Application_Units_Without_State (Context : Asis.Context ) is
    Unit_List : Asis.Compilation_Unit_List :=       
         Asis.Compilation_Units.Compilation_Units (Context); 

begin
    for I in Unit_List'Range loop
        case Asis.Compilation_Units.Unit_Origin (Unit_List (I)) is
           when Asis.An_Application_Unit =>
                Process (Unit_List (I));
           when others => null;
        end case;
    end loop;
end Process_Application_Units_Without_State;

end Unit_Processing_Templates;

