package Bounded_String is

    subtype String_Length is Natural;

    type Variable_String (Maximum_Length : String_Length) is private;
    -- initialized to have a length of 0

    procedure Copy (Target : in out Variable_String; Source : Variable_String);
    procedure Copy (Target : in out Variable_String; Source : String);
    procedure Copy (Target : in out Variable_String; Source : Character);

    procedure Move (Target : in out Variable_String; 
		    Source : in out Variable_String);

    function Image (V : Variable_String) return String;

    -- Value function with maximum length = current length
    function Value (S : String) return Variable_String;

    -- Value function with specified maximum length
    function Value (S : String; Max_Length : Natural) return Variable_String;
    pragma Inline (Image);

    procedure Free (V : in out Variable_String);

    procedure Append (Target : in out Variable_String; 
		      Source : Variable_String);

    procedure Append (Target : in out Variable_String; Source : String);

    procedure Append (Target : in out Variable_String; Source : Character);

    procedure Append (Target : in out Variable_String; 
		      Source : Character; 
		      Count : Natural);

    procedure Insert (Target : in out Variable_String; 
		      At_Pos : Positive; 
		      Source : Variable_String);

    procedure Insert (Target : in out Variable_String; 
		      At_Pos : Positive; 
		      Source : String);

    procedure Insert (Target : in out Variable_String; 
		      At_Pos : Positive; 
		      Source : Character);

    procedure Insert (Target : in out Variable_String; 
		      At_Pos : Positive; 
		      Source : Character; 
		      Count : Natural);

    procedure Delete (Target : in out Variable_String; 
		      At_Pos : Positive; 
		      Count : Natural := 1);

    procedure Replace (Target : in out Variable_String; 
		       At_Pos : Positive; 
		       Source : Character);

    procedure Replace (Target : in out Variable_String; 
		       At_Pos : Positive; 
		       Source : Character; 
		       Count : Natural);

    procedure Replace (Target : in out Variable_String; 
		       At_Pos : Positive; 
		       Source : String);

    procedure Replace (Target : in out Variable_String; 
		       At_Pos : Positive; 
		       Source : Variable_String);

    -- Truncate or extend with fill
    procedure Set_Length (Target : in out Variable_String; 
			  New_Length : Natural; 
			  Fill_With : Character := ' ');

    -- Get information about or contents of a string
    function Length (Source : Variable_String) return Natural;
    function Char_At (Source : Variable_String; At_Pos : Positive) 
		     return Character;

    function Extract (Source : Variable_String; 
		      Start_Pos : Positive; 
		      End_Pos : Natural) return String;

    -- get the allocated length of the string
    function Max_Length (Source : Variable_String) return Natural;
    pragma Inline (Length);
    pragma Inline (Char_At);
    pragma Inline (Max_Length);
private
    type Variable_String (Maximum_Length : String_Length) is
	record
	    Length : String_Length := 0;
	    Contents : String (1 .. Maximum_Length);
	end record;

end Bounded_String;
