with String_Utilities;
procedure Enumeration_Value (S : String; 
			     Result : out Enumeration; 
			     Prefix : out Boolean; 
			     Unique : out Boolean) is
    Already_Matched : Boolean := False;
    Exact : Boolean;
    Match : Boolean;
    Up_S : constant String := String_Utilities.Upper_Case (S);
begin
    Prefix := False;
    Unique := False;
    Result := Enumeration'Last;
    for Enum in Enumeration loop
	declare
	    Enum_Image : constant String := Enumeration'Image (Enum);
	begin
	    Match := Up_S'Length <= Enum_Image'Length and then 
			Up_S = Enum_Image 
				  (Enum_Image'First .. 
				      Enum_Image'First + Up_S'Length - 1);
	    Exact := Match and then (Up_S'Length = Enum_Image'Length);
	end;
	if Exact then
	    Result := Enum;
	    Unique := True;
	    Prefix := False;
	    return;
	elsif Match then
	    Unique := not Already_Matched;
	    Already_Matched := True;
	    Prefix := True;
	    Result := Enum;
	end if;
    end loop;
end Enumeration_Value;
