generic
    type Element is private;
    -- must be a pure value
    -- ie. no initialization or finalization is necessary
    -- = and := are equality and copy

    pragma Must_Be_Constrained (Yes => Element);

package List_Generic is

    type List is private;
    -- may generate garbage
    -- = and := operate on references
    -- "make" constructs lists with structural sharing

    -- constraint error is raised when nil i provided to any of
    --    first, rest, set_first, or set_rest

    function Make (X : Element; L : List) return List;

    function Nil return List;
    function Is_Empty (L : List) return Boolean;

    procedure Free (L : in out List);
    -- make L empty

    function First (L : List) return Element;
    function Rest (L : List) return List;
    procedure Set_Rest (L : List; To_Be : List);
    procedure Set_First (L : List; To_Be : Element);

    function Length (L : List) return Natural;

    type Iterator is limited private;

    procedure Init (Iter : out Iterator; L : List);
    procedure Next (Iter : in out Iterator);
    function Value (Iter : Iterator) return Element;
    function Done (Iter : Iterator) return Boolean;

    --/inline    pragma inline(make);
    --/inline    pragma inline(nil);
    --/inline    pragma inline(is_empty);
    --/inline    pragma inline(free);

    --/inline    pragma inline(first);
    --/inline    pragma inline(rest);
    --/inline    pragma inline(set_rest);
    --/inline    pragma inline(set_first);

    --/inline    pragma inline(init);
    --/inline    pragma inline(next);
    --/inline    pragma inline(value);
    --/inline    pragma inline(done);

private

    type Listdata;
    type List is access Listdata;
    -- variables of type list are initialized to null

    type Listdata is
	record
	    First : Element;
	    Rest : List;
	end record;

    type Iterator is new List;

end List_Generic;
